/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.particles;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TARDISFirework {
    private static final Color[] COLORS;
    private final FireworkMeta meta;

    private TARDISFirework(FireworkMeta meta, boolean isClean) {
        if (isClean) {
            this.meta = meta;
        } else {
            this.meta = TARDISFirework.getCleanMeta();
            this.meta.setPower(meta.getPower());
            this.meta.addEffects((Iterable)meta.getEffects());
        }
    }

    public static TARDISFirework randomize() {
        FireworkMeta meta = TARDISFirework.getCleanMeta();
        meta.setPower(TARDISConstants.RANDOM.nextInt(3) + 1);
        meta.addEffects(TARDISFirework.randomizeEffects(1, 2, 1, 2));
        return new TARDISFirework(meta, true);
    }

    private static int calculateRandom(int min, int max) throws IllegalArgumentException {
        if (min < 0) {
            throw new IllegalArgumentException("Min value can not be lower than 0");
        }
        if (max < 1) {
            throw new IllegalArgumentException("Min value can not be lower than 1");
        }
        if (max < min) {
            throw new IllegalArgumentException("Max value can not be lower than min value");
        }
        return min == max ? min : TARDISConstants.RANDOM.nextInt(max - min + 1) + min;
    }

    private static List<Color> randomizeColors(int min, int max) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int a = 1; a <= TARDISFirework.calculateRandom(min, max); ++a) {
            Color c = COLORS[TARDISConstants.RANDOM.nextInt(COLORS.length)];
            if (colors.contains(c)) continue;
            colors.add(c);
        }
        return colors;
    }

    private static List<FireworkEffect> randomizeEffects(int min, int max, int minColors, int maxColors) {
        ArrayList<FireworkEffect> effects = new ArrayList<FireworkEffect>();
        for (int a = 1; a <= TARDISFirework.calculateRandom(min, max); ++a) {
            effects.add(FireworkEffect.builder().flicker(TARDISConstants.RANDOM.nextBoolean()).with(FireworkEffect.Type.values()[TARDISConstants.RANDOM.nextInt(FireworkEffect.Type.values().length)]).trail(TARDISConstants.RANDOM.nextBoolean()).withColor(TARDISFirework.randomizeColors(minColors, maxColors)).withFade(TARDISFirework.randomizeColors(minColors, maxColors)).build());
        }
        return effects;
    }

    private static FireworkMeta getCleanMeta() {
        return (FireworkMeta)ItemStack.of((Material)Material.FIREWORK_ROCKET).getItemMeta();
    }

    private Firework launch(Location l) {
        Firework f = (Firework)l.getWorld().spawn(l, Firework.class);
        f.setFireworkMeta(this.meta);
        return f;
    }

    public void displayEffects(TARDIS plugin, Location l) {
        final Firework f = this.launch(l);
        new BukkitRunnable(this){

            public void run() {
                f.detonate();
            }
        }.runTaskLater((Plugin)plugin, 1L);
    }

    static {
        DyeColor[] values = DyeColor.values();
        COLORS = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            TARDISFirework.COLORS[i] = values[i].getFireworkColor();
        }
    }
}

