/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.siegemode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.customblocks.TARDISMushroomBlockData;
import me.eccentric_nz.TARDIS.custommodels.keys.Whoniverse;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.siegemode.TARDISSiegeMode;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TARDISSiegeListener
implements Listener {
    private final TARDIS plugin;

    public TARDISSiegeListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSiegeCubeDespawn(ItemDespawnEvent event) {
        ItemStack is = event.getEntity().getItemStack();
        if (!this.isSiegeCube(is)) {
            return;
        }
        if (!this.hasSiegeCubeName(is)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSiegeCubeBreak(BlockBreakEvent event) {
        UUID tluuid;
        Block b = event.getBlock();
        if (!this.isSiegeCube(b)) {
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("world", b.getWorld().getName());
        where.put("x", b.getX());
        where.put("y", b.getY());
        where.put("z", b.getZ());
        ResultSetCurrentLocation rsc = new ResultSetCurrentLocation(this.plugin, where);
        if (!rsc.resultSet()) {
            return;
        }
        event.setCancelled(true);
        int id = rsc.getTardis_id();
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
        if (!rs.resultSet()) {
            return;
        }
        Tardis tardis = rs.getTardis();
        UUID puuid = event.getPlayer().getUniqueId();
        if (!puuid.equals(tluuid = tardis.getUuid())) {
            boolean isCompanion = false;
            if (!tardis.getCompanions().isEmpty()) {
                for (String cuuid : tardis.getCompanions().split(":")) {
                    if (!cuuid.equals(puuid.toString())) continue;
                    isCompanion = true;
                    break;
                }
            }
            if (!isCompanion) {
                this.plugin.getMessenger().send((CommandSender)event.getPlayer(), TardisModule.TARDIS, "SIEGE_COMPANION");
                return;
            }
        }
        String tl = tardis.getOwner();
        ItemStack is = ItemStack.of((Material)TARDISDisplayItem.SIEGE_CUBE.getMaterial(), (int)1);
        ItemMeta im = is.getItemMeta();
        im.displayName((Component)ComponentUtils.toWhite("TARDIS Siege Cube"));
        im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)TARDISDisplayItem.SIEGE_CUBE.getCustomModel().getKey());
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        lore.add(Component.text((String)("Time Lord: " + tl)));
        lore.add(Component.text((String)("ID: " + id)));
        HashMap<String, Object> wherec = new HashMap<String, Object>();
        wherec.put("tardis_id", id);
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherec, true);
        if (rst.resultSet()) {
            rst.getData().forEach(tuuid -> {
                Player p = this.plugin.getServer().getPlayer(tuuid);
                if (p != null && tuuid != tluuid) {
                    String c = p.getName();
                    lore.add(Component.text((String)("Companion: " + c)));
                }
            });
        }
        im.lore(lore);
        is.setItemMeta(im);
        b.setBlockData(TARDISConstants.AIR);
        Item item = b.getWorld().dropItemNaturally(b.getLocation(), is);
        item.setInvulnerable(true);
        this.plugin.getTrackerKeeper().getIsSiegeCube().add(id);
        this.plugin.getTrackerKeeper().getSiegeCarrying().put(puuid, id);
    }

    @EventHandler(ignoreCancelled=true)
    public void onDropSiegeCube(PlayerDropItemEvent event) {
        Item item = event.getItemDrop();
        Player p = event.getPlayer();
        UUID uuid = p.getUniqueId();
        if (!this.plugin.getTrackerKeeper().getSiegeCarrying().containsKey(uuid)) {
            return;
        }
        ItemStack is = item.getItemStack();
        if (!this.isSiegeCube(is)) {
            return;
        }
        if (!this.hasSiegeCubeName(is)) {
            return;
        }
        if (this.plugin.getUtils().inTARDISWorld(p)) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_NO_TARDIS");
            return;
        }
        if (!this.plugin.getPlanetsConfig().getBoolean("planets." + p.getLocation().getWorld().getName() + ".time_travel")) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_NO_WORLD");
            return;
        }
        item.setInvulnerable(true);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            COMPASS d;
            Location loc = item.getLocation();
            int[] start = TARDISTimeTravel.getStartLocation(loc, d = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(p, false)));
            int count = TARDISTimeTravel.safeLocation(start[0], loc.getBlockY(), start[2], start[1], start[3], loc.getWorld(), d);
            if (count > 0) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_NO_SPACE");
                return;
            }
            List lore = is.getItemMeta().lore();
            if (lore == null || lore.size() < 2) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_NO_ID");
                return;
            }
            String[] line2 = ComponentUtils.stripColour((Component)lore.get(1)).split(": ");
            int id = TARDISNumberParsers.parseInt(line2[1]);
            item.remove();
            Block siege = loc.getBlock();
            TARDISDisplayItemUtils.set(TARDISDisplayItem.SIEGE_CUBE, siege, id);
            this.plugin.getTrackerKeeper().getIsSiegeCube().remove(id);
            this.plugin.getTrackerKeeper().getSiegeCarrying().remove(uuid);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("world", loc.getWorld().getName());
            set.put("x", loc.getBlockX());
            set.put("y", loc.getBlockY());
            set.put("z", loc.getBlockZ());
            set.put("direction", d.toString());
            this.plugin.getQueryFactory().doUpdate("current", set, where);
        }, 10L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSiegeCubePlace(BlockPlaceEvent event) {
        ItemStack is = event.getItemInHand();
        if (!this.isSiegeCube(is)) {
            return;
        }
        Player p = event.getPlayer();
        UUID uuid = p.getUniqueId();
        if (!this.plugin.getTrackerKeeper().getSiegeCarrying().containsKey(uuid)) {
            return;
        }
        Location loc = event.getBlock().getLocation();
        if (this.plugin.getUtils().inTARDISWorld(loc)) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_NO_TARDIS");
            return;
        }
        String w = p.getLocation().getWorld().getName();
        if (!this.plugin.getPlanetsConfig().getBoolean("planets." + w + ".time_travel")) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_NO_WORLD");
            return;
        }
        COMPASS d = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(p, false));
        int[] start = TARDISTimeTravel.getStartLocation(loc, d);
        int count = TARDISTimeTravel.safeLocation(start[0], loc.getBlockY(), start[2], start[1], start[3], loc.getWorld(), d);
        if (count > 0) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_NO_SPACE");
            return;
        }
        int id = this.plugin.getTrackerKeeper().getSiegeCarrying().get(uuid);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("world", loc.getWorld().getName());
        set.put("x", loc.getBlockX());
        set.put("y", loc.getBlockY());
        set.put("z", loc.getBlockZ());
        set.put("direction", d.toString());
        this.plugin.getQueryFactory().doUpdate("current", set, where);
        this.plugin.getTrackerKeeper().getIsSiegeCube().remove(id);
        this.plugin.getTrackerKeeper().getSiegeCarrying().remove(uuid);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSiegeCubeInteract(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Action action = event.getAction();
        if (!action.equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Block b = event.getClickedBlock();
        if (!this.isSiegeCube(b)) {
            return;
        }
        Player p = event.getPlayer();
        if (this.plugin.getUtils().inTARDISWorld(p)) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_NO_TARDIS");
        }
        UUID uuid = p.getUniqueId();
        HashMap<String, Object> wherec = new HashMap<String, Object>();
        wherec.put("world", b.getWorld().getName());
        wherec.put("x", b.getX());
        wherec.put("y", b.getY());
        wherec.put("z", b.getZ());
        ResultSetCurrentLocation rsc = new ResultSetCurrentLocation(this.plugin, wherec);
        if (!rsc.resultSet()) {
            return;
        }
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("tardis_id", rsc.getTardis_id());
        ResultSetTardis rst = new ResultSetTardis(this.plugin, wheret, "", false);
        if (!rst.resultSet()) {
            return;
        }
        Tardis tardis = rst.getTardis();
        int id = tardis.getTardisId();
        if (!uuid.equals(tardis.getUuid())) {
            boolean isCompanion = false;
            if (!tardis.getCompanions().isEmpty()) {
                for (String cuuid : tardis.getCompanions().split(":")) {
                    if (!cuuid.equals(uuid.toString())) continue;
                    isCompanion = true;
                    break;
                }
            }
            if (!isCompanion) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_COMPANION");
                return;
            }
        }
        int min = this.plugin.getArtronConfig().getInt("full_charge") / 100 * this.plugin.getArtronConfig().getInt("siege_transfer");
        if (!p.isSneaking()) {
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
            if (!rsp.resultSet()) {
                return;
            }
            int level = rsp.getArtronLevel();
            if (min > level) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_MIN", String.format("%s", min));
                return;
            }
            HashMap<String, Object> wheretl = new HashMap<String, Object>();
            wheretl.put("uuid", uuid.toString());
            HashMap<String, Object> wherea = new HashMap<String, Object>();
            wherea.put("tardis_id", id);
            this.plugin.getQueryFactory().alterEnergyLevel("player_prefs", -min, wheretl, p);
            this.plugin.getQueryFactory().alterEnergyLevel("tardis", min, wherea, p);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_TRANSFER", String.format("%s", min));
        } else {
            if (min > tardis.getArtronLevel()) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_POWER");
                return;
            }
            Location current = b.getLocation();
            BuildData bd = new BuildData(p.getUniqueId().toString());
            bd.setDirection(rsc.getDirection());
            bd.setLocation(current);
            bd.setMalfunction(false);
            bd.setOutside(false);
            bd.setPlayer((OfflinePlayer)p);
            bd.setRebuild(true);
            bd.setSubmarine(rsc.isSubmarine());
            bd.setTardisID(id);
            bd.setThrottle(SpaceTimeThrottle.REBUILD);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), 10L);
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("siege_on", 0);
            HashMap<String, Object> wheres = new HashMap<String, Object>();
            wheres.put("tardis_id", id);
            this.plugin.getQueryFactory().doUpdate("tardis", set, wheres);
            this.plugin.getTrackerKeeper().getInSiegeMode().remove(id);
            if (this.plugin.getConfig().getBoolean("siege.texture")) {
                new TARDISSiegeMode(this.plugin).changeTextures(tardis.getUuid().toString(), tardis.getSchematic(), p, false);
            }
            this.plugin.getMessenger().sendStatus(p, "SIEGE_OFF");
        }
    }

    private boolean isSiegeCube(ItemStack is) {
        Material m = is.getType();
        if (!m.equals((Object)Material.BROWN_MUSHROOM_BLOCK) && !m.equals((Object)Material.CYAN_CONCRETE)) {
            return false;
        }
        ItemMeta im = is.getItemMeta();
        if (im != null) {
            return im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "TARDIS Siege Cube") || im.hasItemModel() && Whoniverse.SIEGE_CUBE.getKey().equals((Object)im.getItemModel());
        }
        return false;
    }

    private boolean isSiegeCube(Block b) {
        Material m = b.getType();
        if (m.equals((Object)Material.BROWN_MUSHROOM_BLOCK) || m.equals((Object)Material.BARRIER)) {
            BlockData blockData = b.getBlockData();
            if (blockData instanceof MultipleFacing) {
                MultipleFacing mf = (MultipleFacing)blockData;
                return mf.getAsString().equals(TARDISMushroomBlockData.BROWN_MUSHROOM_DATA.get(2));
            }
            ItemDisplay tdi = TARDISDisplayItemUtils.get(b);
            return tdi != null && tdi.getItemStack() != null && tdi.getItemStack().getType() == Material.CYAN_CONCRETE;
        }
        return false;
    }

    private boolean hasSiegeCubeName(ItemStack is) {
        return is.hasItemMeta() && is.getItemMeta().hasDisplayName() && ComponentUtils.endsWith(is.getItemMeta().displayName(), "TARDIS Siege Cube");
    }
}

