/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import org.bukkit.Location;
import org.bukkit.util.Vector;

public class TARDISVector3D {
    public final double x;
    public final double y;
    public final double z;

    public TARDISVector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public TARDISVector3D(Location location) {
        this(location.toVector());
    }

    public TARDISVector3D(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Vector cannot be NULL.");
        }
        this.x = vector.getX();
        this.y = vector.getY();
        this.z = vector.getZ();
    }

    public TARDISVector3D add(TARDISVector3D other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be NULL");
        }
        return new TARDISVector3D(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public TARDISVector3D add(double x, double y, double z) {
        return new TARDISVector3D(this.x + x, this.y + y, this.z + z);
    }

    public TARDISVector3D subtract(TARDISVector3D other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be NULL");
        }
        return new TARDISVector3D(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public TARDISVector3D multiply(int factor) {
        return new TARDISVector3D(this.x * (double)factor, this.y * (double)factor, this.z * (double)factor);
    }

    public TARDISVector3D multiply(double factor) {
        return new TARDISVector3D(this.x * factor, this.y * factor, this.z * factor);
    }

    public TARDISVector3D abs() {
        return new TARDISVector3D(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public String toString() {
        return String.format("[x: %s, y: %s, z: %s]", this.x, this.y, this.z);
    }
}

