/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.feature;

import me.eccentric_nz.tardischunkgenerator.worldgen.feature.TARDISTreeData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.WeepingVinesFeature;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.craftbukkit.block.data.CraftBlockData;

public class TreePlacer {
    private final BlockPredicate predicate = BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.OAK_SAPLING, Blocks.SPRUCE_SAPLING, Blocks.BIRCH_SAPLING, Blocks.JUNGLE_SAPLING, Blocks.ACACIA_SAPLING, Blocks.CHERRY_SAPLING, Blocks.DARK_OAK_SAPLING, Blocks.MANGROVE_PROPAGULE, Blocks.DANDELION, Blocks.TORCHFLOWER, Blocks.POPPY, Blocks.BLUE_ORCHID, Blocks.ALLIUM, Blocks.AZURE_BLUET, Blocks.RED_TULIP, Blocks.ORANGE_TULIP, Blocks.WHITE_TULIP, Blocks.PINK_TULIP, Blocks.OXEYE_DAISY, Blocks.CORNFLOWER, Blocks.WITHER_ROSE, Blocks.LILY_OF_THE_VALLEY, Blocks.BROWN_MUSHROOM, Blocks.RED_MUSHROOM, Blocks.WHEAT, Blocks.SUGAR_CANE, Blocks.ATTACHED_PUMPKIN_STEM, Blocks.ATTACHED_MELON_STEM, Blocks.PUMPKIN_STEM, Blocks.MELON_STEM, Blocks.LILY_PAD, Blocks.NETHER_WART, Blocks.COCOA, Blocks.CARROTS, Blocks.POTATOES, Blocks.CHORUS_PLANT, Blocks.CHORUS_FLOWER, Blocks.TORCHFLOWER_CROP, Blocks.PITCHER_CROP, Blocks.BEETROOTS, Blocks.SWEET_BERRY_BUSH, Blocks.WARPED_FUNGUS, Blocks.CRIMSON_FUNGUS, Blocks.WEEPING_VINES, Blocks.WEEPING_VINES_PLANT, Blocks.TWISTING_VINES, Blocks.TWISTING_VINES_PLANT, Blocks.CAVE_VINES, Blocks.CAVE_VINES_PLANT, Blocks.SPORE_BLOSSOM, Blocks.AZALEA, Blocks.FLOWERING_AZALEA, Blocks.MOSS_CARPET, Blocks.PINK_PETALS, Blocks.BIG_DRIPLEAF, Blocks.BIG_DRIPLEAF_STEM, Blocks.SMALL_DRIPLEAF});
    private final RandomSource random = RandomSource.create();

    public void place(TARDISTreeData data, WorldGenLevel level, BlockPos blockPos, ChunkGenerator generator) {
        BlockState base = ((CraftBlockData)Bukkit.createBlockData((Material)data.base())).getState();
        BlockPos pos = null;
        BlockState under = level.getBlockState(blockPos.below());
        if (under == base) {
            pos = blockPos;
        }
        if (pos != null) {
            int i = Mth.nextInt((RandomSource)this.random, (int)4, (int)13);
            if (this.random.nextInt(12) == 0) {
                i *= 2;
            }
            if (!data.planted()) {
                int j = generator.getGenDepth();
                if (pos.getY() + i + 1 >= j) {
                    return;
                }
            }
            boolean flag = !data.planted() && this.random.nextFloat() < 0.06f;
            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 4);
            this.placeStem(level, this.random, data, pos, i, flag);
            this.placeHat(level, this.random, data, pos, i, flag);
        }
    }

    private void placeStem(WorldGenLevel level, RandomSource random, TARDISTreeData data, BlockPos pos, int i, boolean b) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockState stem = ((CraftBlockData)Bukkit.createBlockData((Material)data.stem())).getState();
        int limit = b ? 1 : 0;
        for (int x = -limit; x <= limit; ++x) {
            for (int z = -limit; z <= limit; ++z) {
                boolean edge = b && Mth.abs((int)x) == limit && Mth.abs((int)z) == limit;
                for (int y = 0; y < i; ++y) {
                    mutableBlockPos.setWithOffset((Vec3i)pos, x, y, z);
                    if (!this.isReplaceable(level, (BlockPos)mutableBlockPos, true)) continue;
                    if (data.planted()) {
                        if (!level.getBlockState(mutableBlockPos.below()).isAir()) {
                            level.destroyBlock((BlockPos)mutableBlockPos, false);
                        }
                        level.setBlock((BlockPos)mutableBlockPos, stem, 3);
                        continue;
                    }
                    if (edge) {
                        if (!(random.nextFloat() < 0.1f)) continue;
                        this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos, stem);
                        continue;
                    }
                    this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos, stem);
                }
            }
        }
    }

    private void placeHat(WorldGenLevel level, RandomSource random, TARDISTreeData data, BlockPos blockPos, int i, boolean b) {
        int min;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockState hat = ((CraftBlockData)Bukkit.createBlockData((Material)data.hat())).getState();
        boolean isNetherWart = hat.is(Blocks.NETHER_WART_BLOCK);
        int max = Math.min(random.nextInt(1 + i / 3) + 5, i);
        for (int h = min = i - max; h <= i; ++h) {
            int offset;
            int n = offset = h < i - random.nextInt(3) ? 2 : 1;
            if (max > 8 && h < min + 4) {
                offset = 3;
            }
            if (b) {
                ++offset;
            }
            for (int x = -offset; x <= offset; ++x) {
                for (int z = -offset; z <= offset; ++z) {
                    boolean bx = x == -offset || x == offset;
                    boolean bz = z == -offset || z == offset;
                    boolean notEdge = !bx && !bz && h != i;
                    boolean bxz = bx && bz;
                    boolean notTop = h < min + 3;
                    pos.setWithOffset((Vec3i)blockPos, x, h, z);
                    if (!this.isReplaceable(level, (BlockPos)pos, false)) continue;
                    if (data.planted() && !level.getBlockState(pos.below()).isAir()) {
                        level.destroyBlock((BlockPos)pos, false);
                    }
                    if (notTop) {
                        if (notEdge) continue;
                        this.placeHatDropBlock(level, random, (BlockPos)pos, hat, isNetherWart);
                        continue;
                    }
                    if (notEdge) {
                        this.placeHatBlock(level, random, data, (BlockPos)pos, 0.1f, 0.2f, isNetherWart ? 0.1f : 0.0f);
                        continue;
                    }
                    if (bxz) {
                        this.placeHatBlock(level, random, data, (BlockPos)pos, 0.01f, 0.7f, isNetherWart ? 0.083f : 0.0f);
                        continue;
                    }
                    this.placeHatBlock(level, random, data, (BlockPos)pos, 5.0E-4f, 0.98f, isNetherWart ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void placeHatBlock(WorldGenLevel level, RandomSource random, TARDISTreeData data, BlockPos pos, float f, float f1, float f2) {
        BlockState decor = ((CraftBlockData)Bukkit.createBlockData((Material)data.decor())).getState();
        BlockState hat = ((CraftBlockData)Bukkit.createBlockData((Material)data.hat())).getState();
        if (random.nextFloat() < f) {
            this.setBlock((LevelWriter)level, pos, decor);
        } else if (random.nextFloat() < f1) {
            this.setBlock((LevelWriter)level, pos, hat);
            if (random.nextFloat() < f2) {
                this.tryPlaceWeepingVines(pos, level, random);
            }
        }
    }

    private void placeHatDropBlock(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState state, boolean b) {
        if (level.getBlockState(pos.below()).is(state.getBlock())) {
            this.setBlock((LevelWriter)level, pos, state);
        } else if ((double)random.nextFloat() < 0.15) {
            this.setBlock((LevelWriter)level, pos, state);
            if (b && random.nextInt(11) == 0) {
                this.tryPlaceWeepingVines(pos, level, random);
            }
        }
    }

    private void tryPlaceWeepingVines(BlockPos pos, WorldGenLevel level, RandomSource random) {
        BlockPos.MutableBlockPos down = pos.mutable().move(Direction.DOWN);
        if (level.isEmptyBlock((BlockPos)down)) {
            int i = Mth.nextInt((RandomSource)random, (int)1, (int)5);
            if (random.nextInt(7) == 0) {
                i *= 2;
            }
            WeepingVinesFeature.placeWeepingVinesColumn((LevelAccessor)level, (RandomSource)random, (BlockPos.MutableBlockPos)down, (int)i, (int)23, (int)25);
        }
    }

    private boolean isReplaceable(WorldGenLevel level, BlockPos pos, boolean b) {
        if (level.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::canBeReplaced)) {
            return true;
        }
        return b && this.predicate.test((Object)level, (Object)pos);
    }

    protected void setBlock(LevelWriter writer, BlockPos pos, BlockState state) {
        writer.setBlock(pos, state, 3);
    }
}

