/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.command;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMQueryFactory;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TVMCommandCoords {
    private final TARDIS plugin;

    public TVMCommandCoords(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean execute(Player player, String[] args) {
        int actual;
        String uuid;
        Location l;
        int required;
        if (!TARDISPermission.hasPermission(player, "vm.teleport")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_CMD");
            return true;
        }
        Parameters params = new Parameters(player, Flag.getAPIFlags());
        ArrayList<String> worlds = new ArrayList<String>();
        switch (args.length) {
            case 1: 
            case 2: 
            case 3: {
                if (this.plugin.getServer().getWorld(args[0]) == null) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NO_WORLD");
                    return true;
                }
                if (!this.containsIgnoreCase(args[0], this.plugin.getTardisAPI().getWorlds())) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NO_TRAVEL");
                    return true;
                }
                required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.world");
                worlds.add(args[0]);
                l = this.plugin.getTardisAPI().getRandomLocation(worlds, null, params);
                break;
            }
            case 4: {
                double z;
                double y;
                double x;
                World w;
                required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.coords");
                if (args[0].contains("~")) {
                    w = player.getLocation().getWorld();
                } else {
                    w = this.plugin.getServer().getWorld(args[0]);
                    if (w == null) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NO_WORLD");
                        return true;
                    }
                    if (!this.containsIgnoreCase(args[0], this.plugin.getTardisAPI().getWorlds())) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NO_TRAVEL");
                        return true;
                    }
                }
                try {
                    if (args[1].startsWith("~")) {
                        Location tl = player.getLocation();
                        double tx = tl.getX();
                        double ty = tl.getY();
                        double tz = tl.getZ();
                        x = tx + Double.parseDouble(args[1].substring(1));
                        y = ty + Double.parseDouble(args[2].substring(1));
                        z = tz + Double.parseDouble(args[3].substring(1));
                    } else {
                        x = Double.parseDouble(args[1]);
                        y = Double.parseDouble(args[2]);
                        z = Double.parseDouble(args[3]);
                    }
                }
                catch (NumberFormatException e) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_COORDS");
                    return true;
                }
                l = new Location(w, x, y, z);
                if (l.getBlock().getType().equals((Object)Material.AIR)) break;
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_ADJUST");
                int highest = l.getWorld().getHighestBlockYAt(l);
                l.setY((double)highest);
                break;
            }
            default: {
                required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.random");
                l = this.plugin.getTardisAPI().getRandomLocation(this.plugin.getTardisAPI().getWorlds(), null, params);
            }
        }
        ArrayList<Player> players = new ArrayList<Player>();
        players.add(player);
        if (this.plugin.getVortexConfig().getBoolean("allow.multiple")) {
            for (Entity e : player.getNearbyEntities(0.5, 0.5, 0.5)) {
                if (!(e instanceof Player) || e.getUniqueId().equals(player.getUniqueId())) continue;
                players.add((Player)e);
            }
        }
        if (!TVMUtils.checkTachyonLevel(uuid = player.getUniqueId().toString(), actual = required * players.size())) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NEED_TACHYON", actual);
            return true;
        }
        if (l != null) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_STANDBY");
            while (!l.getChunk().isLoaded()) {
                l.getChunk().load();
            }
            TVMUtils.movePlayers(players, l, player.getLocation().getWorld());
            new TVMQueryFactory(this.plugin).alterTachyons(uuid, -actual);
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PARAMETERS");
        }
        return true;
    }

    private boolean containsIgnoreCase(String str, List<String> list) {
        for (String s : list) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }
}

