/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.daleks;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.custommodels.keys.DalekVariant;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DalekEquipment {
    public static void set(LivingEntity le, boolean disguise) {
        le.getPersistentDataContainer().set(TARDISWeepingAngels.DALEK, PersistentDataType.INTEGER, (Object)Monster.DALEK.ordinal());
        ItemStack helmet = ItemStack.of((Material)Material.SLIME_BALL, (int)1);
        ItemMeta headMeta = helmet.getItemMeta();
        headMeta.displayName((Component)Component.text((String)"Dalek Head"));
        headMeta.setItemModel(DalekEquipment.getRandomModel());
        helmet.setItemMeta(headMeta);
        EntityEquipment ee = le.getEquipment();
        ee.setHelmet(helmet);
        ee.setChestplate(null);
        ee.setLeggings(null);
        ee.setBoots(null);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)TARDIS.plugin, () -> {
            PotionEffect invisibility = new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, true, false);
            le.addPotionEffect(invisibility);
            PotionEffect resistance = new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 360000, 3, true, false);
            le.addPotionEffect(resistance);
        });
        if (!disguise) {
            ee.setHelmetDropChance(0.0f);
            ItemStack bow = ItemStack.of((Material)Material.BOW, (int)1);
            ItemMeta bim = bow.getItemMeta();
            bim.setItemModel(DalekVariant.DALEK_BOW.getKey());
            bow.setItemMeta(bim);
            ee.setItemInMainHand(bow);
            ee.setItemInMainHandDropChance(0.0f);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)TARDIS.plugin, () -> {
                PotionEffect resistance = new PotionEffect(PotionEffectType.RESISTANCE, 360000, 1, true, false);
                le.addPotionEffect(resistance);
                AttributeInstance attribute = le.getAttribute(Attribute.MAX_HEALTH);
                attribute.setBaseValue(30.0);
                le.setHealth(30.0);
                le.setCanPickupItems(false);
                le.setRemoveWhenFarAway(false);
                le.setPersistent(true);
            });
        }
    }

    private static NamespacedKey getRandomModel() {
        if (TARDISConstants.RANDOM.nextBoolean()) {
            return DalekVariant.DALEK_BRASS.getKey();
        }
        switch (TARDISConstants.RANDOM.nextInt(1, 17)) {
            case 1: {
                return DalekVariant.DALEK_WHITE.getKey();
            }
            case 2: {
                return DalekVariant.DALEK_ORANGE.getKey();
            }
            case 3: {
                return DalekVariant.DALEK_MAGENTA.getKey();
            }
            case 4: {
                return DalekVariant.DALEK_LIGHT_BLUE.getKey();
            }
            case 5: {
                return DalekVariant.DALEK_YELLOW.getKey();
            }
            case 6: {
                return DalekVariant.DALEK_LIME.getKey();
            }
            case 7: {
                return DalekVariant.DALEK_PINK.getKey();
            }
            case 8: {
                return DalekVariant.DALEK_GRAY.getKey();
            }
            case 9: {
                return DalekVariant.DALEK_LIGHT_GRAY.getKey();
            }
            case 10: {
                return DalekVariant.DALEK_CYAN.getKey();
            }
            case 11: {
                return DalekVariant.DALEK_BLUE.getKey();
            }
            case 12: {
                return DalekVariant.DALEK_PURPLE.getKey();
            }
            case 13: {
                return DalekVariant.DALEK_GREEN.getKey();
            }
            case 14: {
                return DalekVariant.DALEK_BROWN.getKey();
            }
            case 15: {
                return DalekVariant.DALEK_RED.getKey();
            }
            case 16: {
                return DalekVariant.DALEK_BLACK.getKey();
            }
        }
        return DalekVariant.DALEK_BRASS.getKey();
    }
}

