/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control.actions;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBackLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class FastReturnAction {
    private final TARDIS plugin;

    public FastReturnAction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void clickButton(Player player, int id, Tardis tardis) {
        if (this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id) || !tardis.isHandbrakeOn() && !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id) || this.plugin.getTrackerKeeper().getHasRandomised().contains(id)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
            return;
        }
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            this.plugin.getTrackerKeeper().getHasRandomised().add(id);
        }
        int cost = this.plugin.getArtronConfig().getInt("travel");
        if (tardis.getArtronLevel() < cost) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
            return;
        }
        HashMap<String, Object> wherebl = new HashMap<String, Object>();
        wherebl.put("tardis_id", id);
        ResultSetBackLocation rsb = new ResultSetBackLocation(this.plugin, wherebl);
        if (rsb.resultSet()) {
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (rsc.resultSet()) {
                if (!this.compareCurrentToBack(rsc.getCurrent().location(), rsb)) {
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("world", rsb.getWorld().getName());
                    set.put("x", rsb.getX());
                    set.put("y", rsb.getY());
                    set.put("z", rsb.getZ());
                    set.put("direction", rsb.getDirection().toString());
                    set.put("submarine", rsb.isSubmarine() ? 1 : 0);
                    HashMap<String, Object> wherel = new HashMap<String, Object>();
                    wherel.put("tardis_id", id);
                    this.plugin.getQueryFactory().doSyncUpdate("next", set, wherel);
                    this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(cost, TravelType.BACK));
                    this.plugin.getTrackerKeeper().getRescue().remove(id);
                    if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                        new TARDISLand(this.plugin, id, player).exitVortex();
                        this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.BACK, id));
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREV_SET", rsb.getWorld().getName() + ":" + rsb.getX() + ":" + rsb.getY() + ":" + rsb.getZ(), !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NO_BACK");
                }
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREV_NOT_FOUND");
        }
    }

    private boolean compareCurrentToBack(Location c, ResultSetBackLocation b) {
        return c.getWorld().equals((Object)b.getWorld()) && c.getBlockX() == b.getX() && c.getBlockY() == b.getY() && c.getBlockZ() == b.getZ();
    }
}

