/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class TARDISFarmingConverter {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public TARDISFarmingConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Statement statement = null;
        Statement ps = null;
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            statement = this.connection.createStatement();
            String farmQuery = "SELECT farm_id FROM " + this.prefix + "farming";
            ResultSet rsf = statement.executeQuery(farmQuery);
            if (!rsf.isBeforeFirst()) {
                HashMap<String, Boolean> rooms = new HashMap<String, Boolean>();
                rooms.put("birdcage", false);
                rooms.put("farm", false);
                rooms.put("hutch", false);
                rooms.put("igloo", false);
                rooms.put("stable", false);
                rooms.put("stall", false);
                rooms.put("village", false);
                StringBuilder tardisFarms = new StringBuilder("SELECT tardis_id, ");
                String check = this.plugin.getConfig().getString("storage.database").equals("sqlite") ? "SELECT sql FROM sqlite_master WHERE tbl_name = '" + this.prefix + "tardis' AND sql LIKE '%%%s%%'" : "SHOW COLUMNS FROM " + this.prefix + "tardis LIKE '%s'";
                for (Map.Entry r : rooms.entrySet()) {
                    String rquery = String.format(check, r.getKey());
                    ResultSet rsr = statement.executeQuery(rquery);
                    if (!rsr.isBeforeFirst()) continue;
                    tardisFarms.append((String)r.getKey()).append(", ");
                    rooms.put((String)r.getKey(), true);
                }
                tardisFarms.delete(tardisFarms.length() - 2, tardisFarms.length());
                tardisFarms.append(" FROM ").append(this.prefix).append("tardis");
                ResultSet rstf = statement.executeQuery(tardisFarms.toString());
                String updateFarms = String.format("INSERT INTO %sfarming (tardis_id, birdcage, farm, hutch, igloo, stable, stall, village) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", this.prefix);
                ps = this.connection.prepareStatement(updateFarms);
                if (rstf.isBeforeFirst()) {
                    while (rstf.next()) {
                        String birdcage = (Boolean)rooms.get("birdcage") != false ? rstf.getString("birdcage") : "";
                        String farm = (Boolean)rooms.get("farm") != false ? rstf.getString("farm") : "";
                        String hutch = (Boolean)rooms.get("hutch") != false ? rstf.getString("hutch") : "";
                        String igloo = (Boolean)rooms.get("igloo") != false ? rstf.getString("igloo") : "";
                        String stable = (Boolean)rooms.get("stable") != false ? rstf.getString("stable") : "";
                        String stall = (Boolean)rooms.get("stall") != false ? rstf.getString("stall") : "";
                        String village = (Boolean)rooms.get("village") != false ? rstf.getString("village") : "";
                        ps.setInt(1, rstf.getInt("tardis_id"));
                        ps.setString(2, birdcage);
                        ps.setString(3, farm);
                        ps.setString(4, hutch);
                        ps.setString(5, igloo);
                        ps.setString(6, stable);
                        ps.setString(7, stall);
                        ps.setString(8, village);
                        ps.addBatch();
                        ++i;
                    }
                }
                if (i > 0) {
                    ps.executeBatch();
                    this.connection.commit();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " farming records");
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Conversion error for condenser materials! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing condenser table (converting IDs)! " + e.getMessage());
            }
        }
    }
}

