/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.lab;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bamboo;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SuperFertisliserListener
implements Listener {
    private final TARDIS plugin;
    private final HashMap<Material, TreeType> TREE_LOOKUP = new HashMap<Material, TreeType>(){
        {
            this.put(Material.OAK_SAPLING, TreeType.TREE);
            this.put(Material.DARK_OAK_SAPLING, TreeType.DARK_OAK);
            this.put(Material.ACACIA_SAPLING, TreeType.ACACIA);
            this.put(Material.JUNGLE_SAPLING, TreeType.SMALL_JUNGLE);
            this.put(Material.SPRUCE_SAPLING, TreeType.REDWOOD);
            this.put(Material.BIRCH_SAPLING, TreeType.BIRCH);
            this.put(Material.CHORUS_FLOWER, TreeType.CHORUS_PLANT);
            this.put(Material.RED_MUSHROOM, TreeType.RED_MUSHROOM);
            this.put(Material.BROWN_MUSHROOM, TreeType.BROWN_MUSHROOM);
            this.put(Material.CRIMSON_FUNGUS, TreeType.CRIMSON_FUNGUS);
            this.put(Material.WARPED_FUNGUS, TreeType.WARPED_FUNGUS);
        }
    };
    private final Set<Material> TREES = new HashSet<Material>();

    public SuperFertisliserListener(TARDIS plugin) {
        this.plugin = plugin;
        this.TREES.add(Material.OAK_SAPLING);
        this.TREES.add(Material.DARK_OAK_SAPLING);
        this.TREES.add(Material.ACACIA_SAPLING);
        this.TREES.add(Material.JUNGLE_SAPLING);
        this.TREES.add(Material.SPRUCE_SAPLING);
        this.TREES.add(Material.BIRCH_SAPLING);
        this.TREES.add(Material.CHORUS_FLOWER);
        this.TREES.add(Material.RED_MUSHROOM);
        this.TREES.add(Material.BROWN_MUSHROOM);
        this.TREES.add(Material.CRIMSON_FUNGUS);
        this.TREES.add(Material.WARPED_FUNGUS);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSuperFertilise(BlockFertilizeEvent event) {
        ItemStack is;
        Player player = event.getPlayer();
        if (player != null && (is = player.getInventory().getItemInMainHand()).getType() == Material.BONE_MEAL && is.hasItemMeta() && is.getItemMeta().hasDisplayName() && ComponentUtils.endsWith(is.getItemMeta().displayName(), "Super Fertiliser") && is.getItemMeta().hasItemModel()) {
            event.setCancelled(true);
            Block block = event.getBlock();
            boolean removeItem = false;
            if (this.plugin.getPluginRespect().getRespect(block.getLocation(), new Parameters(player, Flag.getNoMessageFlags()))) {
                switch (block.getType()) {
                    case PUMPKIN_STEM: 
                    case MELON_STEM: 
                    case CARROTS: 
                    case WHEAT: 
                    case POTATOES: 
                    case BEETROOTS: 
                    case SWEET_BERRY_BUSH: {
                        Ageable ageable = (Ageable)block.getBlockData();
                        ageable.setAge(ageable.getMaximumAge());
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> block.setBlockData((BlockData)ageable), 3L);
                        removeItem = true;
                        break;
                    }
                    case BAMBOO_SAPLING: {
                        Bamboo bamboo = (Bamboo)Material.BAMBOO.createBlockData();
                        bamboo.setAge(1);
                        bamboo.setStage(1);
                        block.setBlockData((BlockData)bamboo);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            Block last = block;
                            for (int i = 1; i < 8; ++i) {
                                Block b;
                                last = b = block.getRelative(BlockFace.UP, i);
                                if (!b.getType().isAir()) break;
                                b.setBlockData((BlockData)bamboo);
                            }
                            bamboo.setLeaves(Bamboo.Leaves.LARGE);
                            last.setBlockData((BlockData)bamboo);
                        }, 3L);
                        removeItem = true;
                        break;
                    }
                }
            }
            if (removeItem && !player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                int amount = is.getAmount() - 1;
                if (amount > 0) {
                    player.getInventory().getItemInMainHand().setAmount(amount);
                } else {
                    player.getInventory().setItemInMainHand(null);
                }
                player.updateInventory();
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSuperFertiliseInteract(PlayerInteractEvent event) {
        Player player;
        ItemStack is;
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null && this.TREES.contains(block.getType()) && (is = (player = event.getPlayer()).getInventory().getItemInMainHand()).getType() == Material.BONE_MEAL && is.hasItemMeta() && is.getItemMeta().hasDisplayName() && ComponentUtils.endsWith(is.getItemMeta().displayName(), "Super Fertiliser") && is.getItemMeta().hasItemModel()) {
            event.setCancelled(true);
            TreeType treeType = this.TREE_LOOKUP.get(block.getType());
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                block.setBlockData(TARDISConstants.AIR);
                block.getWorld().generateTree(block.getLocation(), (Random)ThreadLocalRandom.current(), treeType);
            }, 3L);
            int amount = is.getAmount() - 1;
            if (amount > 0) {
                player.getInventory().getItemInMainHand().setAmount(amount);
            } else {
                player.getInventory().setItemInMainHand(null);
            }
            player.updateInventory();
        }
    }
}

