/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardissonicblaster;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public class TARDISSonicBlasterAction {
    private final TARDIS plugin;

    public TARDISSonicBlasterAction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void blast(Location target, COMPASS direction, double angle, double distance, double power, UUID uuid) {
        if (distance > this.plugin.getBlasterSettings().getMaxUsableDistance()) {
            return;
        }
        switch ((int)distance) {
            case 1: {
                this.drill(target, direction, angle, uuid);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
        this.plugin.getBlasterSettings().getIsBlasting().remove(uuid);
    }

    private void drill(Location target, COMPASS direction, double angle, UUID uuid) {
        int max_blocks = this.plugin.getBlasterConfig().getInt("max_blocks");
        int block_count = 0;
        int depth = this.determineHorizontalSectionDepth(angle);
        System.out.println("depth: " + depth);
        int ax = this.getAddX(direction);
        int az = this.getAddZ(direction);
        int x = target.getBlockX();
        int y = target.getBlockY();
        int z = target.getBlockZ();
        int l = 0;
        World w = target.getWorld();
        if (depth != 1) {
            block5: while (block_count <= max_blocks) {
                for (int i = 0; i < depth; ++i) {
                    int xx = x + i * ax;
                    int yy = y - l;
                    int zz = z + i * az;
                    w.getBlockAt(xx, yy, zz).setType(Material.AIR);
                    w.getBlockAt(xx, yy - 1, zz).setType(Material.AIR);
                    if ((block_count += 2) <= max_blocks) continue;
                    this.plugin.getBlasterSettings().getIsBlasting().put(uuid, System.currentTimeMillis());
                    break block5;
                }
                ++l;
                switch (direction) {
                    case NORTH: {
                        z -= depth - 1;
                        continue block5;
                    }
                    case EAST: {
                        x += depth - 1;
                        continue block5;
                    }
                    case SOUTH: {
                        z += depth - 1;
                        continue block5;
                    }
                }
                x -= depth - 1;
            }
        }
    }

    private int determineHorizontalSectionDepth(double angle) {
        if (angle < -52.0 || angle > 52.0) {
            return 1;
        }
        if (angle < -44.0 && angle > -53.0 || angle > 44.0 && angle < 53.0) {
            return 2;
        }
        if (angle < -36.0 && angle > -45.0 || angle > 36.0 && angle < 45.0) {
            return 3;
        }
        if (angle < -28.0 && angle > -37.0 || angle > 28.0 && angle < 37.0) {
            return 4;
        }
        if (angle < -20.0 && angle > -29.0 || angle > 20.0 && angle < 29.0) {
            return 5;
        }
        if (angle < -12.0 && angle > -21.0 || angle > 12.0 && angle < 21.0) {
            return 6;
        }
        if (angle < -4.0 && angle > -13.0 || angle > 4.0 && angle < 13.0) {
            return 7;
        }
        return 8;
    }

    private int getAddX(COMPASS direction) {
        return switch (direction) {
            case COMPASS.EAST -> 1;
            case COMPASS.WEST -> -1;
            default -> 0;
        };
    }

    private int getAddZ(COMPASS direction) {
        return switch (direction) {
            case COMPASS.SOUTH -> 1;
            case COMPASS.NORTH -> -1;
            default -> 0;
        };
    }
}

