/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISWorldRemover;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISSpace;
import org.bukkit.command.CommandSender;

public class TARDISWorldConfig {
    private final TARDIS plugin;

    public TARDISWorldConfig(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void check() {
        if (this.plugin.getConfig().getBoolean("creation.create_worlds")) {
            if (this.plugin.getConfig().getBoolean("abandon.enabled")) {
                this.plugin.getConfig().set("abandon.enabled", (Object)false);
                this.plugin.saveConfig();
                this.plugin.getLogger().log(Level.SEVERE, "Abandoned TARDISes were disabled as create_worlds is true!");
            }
            if (this.plugin.getConfig().getBoolean("creation.default_world")) {
                this.plugin.getConfig().set("creation.default_world", (Object)false);
                this.plugin.saveConfig();
                this.plugin.getLogger().log(Level.SEVERE, "default_world was disabled as create_worlds is true!");
            }
            this.plugin.getPlanetsConfig().set("planets.TARDIS_TimeVortex.enabled", (Object)false);
            try {
                this.plugin.getPlanetsConfig().save(new File(this.plugin.getDataFolder(), "planets.yml"));
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Couldn't save planets.yml!");
            }
        }
        if (this.plugin.getConfig().getBoolean("creation.create_worlds_with_perms") && this.plugin.getConfig().getBoolean("abandon.enabled")) {
            this.plugin.getConfig().set("abandon.enabled", (Object)false);
            this.plugin.saveConfig();
            this.plugin.getLogger().log(Level.SEVERE, "Abandoned TARDISes were disabled as create_worlds_with_perms is true!");
        }
        this.plugin.getCleanUpWorlds().forEach(w -> new TARDISWorldRemover(this.plugin).cleanWorld((String)w));
        if (!this.plugin.getConfig().getBoolean("creation.default_world")) {
            return;
        }
        String defWorld = this.plugin.getConfig().getString("creation.default_world_name", "TARDIS_TimeVortex");
        if (this.plugin.getServer().getWorld(defWorld) == null) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Default world specified, but it doesn't exist! Trying to create it now...");
            new TARDISSpace(this.plugin).createDefaultWorld(defWorld);
        }
    }
}

