/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.CircuitVariant;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class TARDISCircuitRepairListener
implements Listener {
    private final TARDIS plugin;
    private final HashMap<List<Float>, String> circuits = new HashMap();

    public TARDISCircuitRepairListener(TARDIS plugin) {
        this.plugin = plugin;
        this.circuits.put(CircuitVariant.ARS.getFloats(), "ars");
        this.circuits.put(CircuitVariant.CHAMELEON.getFloats(), "chameleon");
        this.circuits.put(CircuitVariant.INPUT.getFloats(), "input");
        this.circuits.put(CircuitVariant.INVISIBILITY.getFloats(), "invisibility");
        this.circuits.put(CircuitVariant.MATERIALISATION.getFloats(), "materialisation");
        this.circuits.put(CircuitVariant.MEMORY.getFloats(), "memory");
        this.circuits.put(CircuitVariant.RANDOM.getFloats(), "randomiser");
        this.circuits.put(CircuitVariant.SCANNER.getFloats(), "scanner");
        this.circuits.put(CircuitVariant.TEMPORAL.getFloats(), "temporal");
        this.circuits.put(CircuitVariant.TELEPATHIC.getFloats(), "telepathic");
        this.circuits.put(CircuitVariant.ARS_DAMAGED.getFloats(), "ars");
        this.circuits.put(CircuitVariant.CHAMELEON_DAMAGED.getFloats(), "chameleon");
        this.circuits.put(CircuitVariant.INPUT_DAMAGED.getFloats(), "input");
        this.circuits.put(CircuitVariant.INVISIBILITY_DAMAGED.getFloats(), "invisibility");
        this.circuits.put(CircuitVariant.MATERIALISATION_DAMAGED.getFloats(), "materialisation");
        this.circuits.put(CircuitVariant.MEMORY_DAMAGED.getFloats(), "memory");
        this.circuits.put(CircuitVariant.RANDOM_DAMAGED.getFloats(), "randomiser");
        this.circuits.put(CircuitVariant.SCANNER_DAMAGED.getFloats(), "scanner");
        this.circuits.put(CircuitVariant.TEMPORAL_DAMAGED.getFloats(), "temporal");
        this.circuits.put(CircuitVariant.TELEPATHIC_DAMAGED.getFloats(), "telepathic");
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteract(InventoryClickEvent event) {
        if (!event.getInventory().getType().equals((Object)InventoryType.ANVIL)) {
            return;
        }
        if (event.getRawSlot() != 2) {
            return;
        }
        AnvilInventory anvil = (AnvilInventory)event.getInventory();
        ItemStack[] items = anvil.getContents();
        ItemStack first = items[0];
        if (first == null || !first.getType().equals((Object)Material.GLOWSTONE_DUST) || !first.hasItemMeta() || first.getAmount() != 1) {
            return;
        }
        ItemMeta fim = first.getItemMeta();
        if (!fim.hasDisplayName()) {
            return;
        }
        String dnf = ComponentUtils.stripColour(fim.displayName());
        if (dnf.startsWith("TARDIS") && dnf.endsWith("Circuit") && fim.hasLore()) {
            int repair_max;
            List flore = fim.lore();
            String stripped = ComponentUtils.stripColour((Component)flore.get(1));
            if (stripped.equals("unlimited")) {
                return;
            }
            int left = TARDISNumberParsers.parseInt(stripped);
            CustomModelDataComponent component = fim.getCustomModelDataComponent();
            List<Float> floats = !component.getFloats().isEmpty() ? component.getFloats() : CircuitVariant.ARS.getFloats();
            int uses = this.plugin.getConfig().getInt("circuits.uses." + this.circuits.get(floats));
            if (left >= uses) {
                return;
            }
            ItemStack two = items[1];
            if (two == null || !two.getType().equals((Object)Material.REDSTONE)) {
                return;
            }
            int amount = two.getAmount();
            int repair_to = amount > (repair_max = uses - left) ? uses : left + amount;
            int remaining = amount > repair_max ? amount - repair_max : 0;
            ItemStack clone = first.clone();
            ItemMeta cim = clone.getItemMeta();
            ArrayList<TextComponent> clore = new ArrayList<TextComponent>();
            clore.add(Component.text((String)"Uses left"));
            clore.add(Component.text((int)repair_to, (TextColor)NamedTextColor.YELLOW));
            cim.lore(clore);
            clone.setItemMeta(cim);
            anvil.setItem(0, clone);
            if (remaining > 0) {
                anvil.setItem(1, ItemStack.of((Material)Material.REDSTONE, (int)remaining));
            } else {
                anvil.setItem(1, ItemStack.of((Material)Material.AIR));
            }
        }
    }
}

