/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.bStats;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class CondenserCounts {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    CondenserCounts(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Integer> getCounts() {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT block_data, block_count FROM " + this.prefix + "condenser";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst() && rs.isBeforeFirst()) {
                while (rs.next()) {
                    String block = rs.getString("block_data");
                    int amount = rs.getInt("block_count");
                    int count = data.containsKey(block) ? data.get(block) + amount : amount;
                    data.put(block, count);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for condenser getting block counts! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing condenser table getting block counts! " + e.getMessage());
            }
        }
        return data;
    }
}

