/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.blueprints;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlueprint;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISPermission {
    public static boolean hasPermission(Player player, String node) {
        if (player.hasPermission(node)) {
            return true;
        }
        if (TARDIS.plugin.getConfig().getBoolean("modules.blueprints")) {
            return TARDISPermission.hasBlueprintPermission(player.getUniqueId().toString(), node);
        }
        return false;
    }

    public static boolean hasPermission(OfflinePlayer offlinePlayer, String node) {
        Player player = offlinePlayer.getPlayer();
        return player != null && TARDISPermission.hasPermission(player, node);
    }

    public static boolean hasPermission(UUID uuid, String node) {
        Player player = TARDIS.plugin.getServer().getPlayer(uuid);
        return player != null && TARDISPermission.hasPermission(player, node);
    }

    public static boolean hasPermission(CommandSender sender, String node) {
        if (sender.hasPermission(node)) {
            return true;
        }
        if (TARDIS.plugin.getConfig().getBoolean("modules.blueprints") && sender instanceof Player) {
            return TARDISPermission.hasBlueprintPermission(((Player)sender).getUniqueId().toString(), node);
        }
        return false;
    }

    public static boolean isNegated(Player player, String node) {
        return player.isPermissionSet(node) && !player.hasPermission(node);
    }

    private static boolean hasBlueprintPermission(String uuid, String node) {
        return new ResultSetBlueprint(TARDIS.plugin).getPerm(uuid, node);
    }
}

