/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.handles;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class TARDISHandlesTimeCommand {
    private final TARDIS plugin;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("h:mm a");

    TARDISHandlesTimeCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean sayTime(Player player) {
        long minecraftTime = player.getWorld().getTime();
        String daynight = TARDISStaticUtils.getTime(minecraftTime);
        LocalDate date = LocalDate.now();
        String formatted = date.format(this.formatter);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            this.plugin.getMessenger().handlesSend(player, "HANDLES_TIME", minecraftTime, daynight, this.parseTime(minecraftTime));
            this.plugin.getMessenger().handlesSend(player, "HANDLES_SERVER_TIME", formatted);
        }, 2L);
        return true;
    }

    private String parseTime(long time) {
        long hours = time / 1000L + 6L;
        long minutes = time % 1000L * 60L / 1000L;
        String ampm = "AM";
        if (hours >= 12L) {
            hours -= 12L;
            ampm = "PM";
        }
        if (hours == 0L) {
            hours = 12L;
        }
        String mm = minutes < 10L ? "0" + minutes : "" + minutes;
        return hours + ":" + mm + " " + ampm;
    }
}

