/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TARDISNetherPortalCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final ImmutableList<String> ENVIRON_SUBS = ImmutableList.of((Object)"overworld", (Object)"nether");

    public TARDISNetherPortalCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisnetherportal")) {
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (player == null) {
                if (args.length < 4) {
                    new TARDISCommandHelper(this.plugin).getCommand("tardisnetherportal", sender);
                    return true;
                }
                int x = TARDISNumberParsers.parseInt(args[0]);
                int y = TARDISNumberParsers.parseInt(args[1]);
                int z = TARDISNumberParsers.parseInt(args[2]);
                return this.o2n(sender, x, y, z, args[3].equalsIgnoreCase("overworld"));
            }
            return this.o2n(player);
        }
        return false;
    }

    private boolean o2n(Player player) {
        int dz;
        int dx;
        String message;
        Location l = player.getLocation();
        boolean overworld = !l.getWorld().getEnvironment().equals((Object)World.Environment.NETHER);
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        if (y > 123 || y < 1) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "O2N_Y");
            return false;
        }
        String d = TARDISStaticUtils.getPlayersDirection(player, false);
        String string = message = overworld ? "O2N_COORDS_N" : "O2N_COORDS_O";
        if (overworld) {
            dx = x / 8;
            dz = z / 8;
        } else {
            dx = x * 8;
            dz = z * 8;
        }
        String coords = "X: " + dx + ", Y: " + y + ", Z: " + dz + ", facing " + d;
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message, coords);
        return true;
    }

    private boolean o2n(CommandSender sender, int x, int y, int z, boolean overworld) {
        int dz;
        int dx;
        String message;
        if (y > 123 || y < 1) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "O2N_Y");
            return false;
        }
        String string = message = overworld ? "O2N_COORDS_N" : "O2N_COORDS_O";
        if (overworld) {
            dx = x / 8;
            dz = z / 8;
        } else {
            dx = x * 8;
            dz = z * 8;
        }
        String coords = "X: " + dx + ", Y: " + y + ", Z: " + dz;
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, message, coords);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 4) {
            return this.partial(args[3], (Collection<String>)this.ENVIRON_SUBS);
        }
        return ImmutableList.of();
    }
}

