/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

class TARDISSQLDelete
implements Runnable {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String table;
    private final HashMap<String, Object> where;
    private final String prefix;

    TARDISSQLDelete(TARDIS plugin, String table, HashMap<String, Object> where) {
        this.plugin = plugin;
        this.table = table;
        this.where = where;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Statement statement = null;
        StringBuilder sbw = new StringBuilder();
        this.where.forEach((key, value) -> {
            sbw.append((String)key).append(" = ");
            if (value instanceof String || value instanceof UUID) {
                sbw.append("'").append(value).append("' AND ");
            } else {
                sbw.append(value).append(" AND ");
            }
        });
        this.where.clear();
        String values = sbw.substring(0, sbw.length() - 5);
        String query = "DELETE FROM " + this.prefix + this.table + " WHERE " + values;
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            statement.executeUpdate(query);
        }
        catch (SQLException e) {
            this.plugin.debug("Delete error for " + this.table + "! " + e.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing " + this.table + "! " + e.getMessage());
            }
        }
    }
}

