/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class TARDISVortexManipulatorTransfer {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String basePath;
    private final TARDIS plugin;
    private final String prefix;
    private final String vm_prefix;
    private boolean isMySQL;
    private FileConfiguration configuration;

    public TARDISVortexManipulatorTransfer(TARDIS plugin) {
        this.plugin = plugin;
        this.basePath = String.valueOf(this.plugin.getServer().getWorldContainer()) + File.separator + "plugins" + File.separator + "TARDISVortexManipulator" + File.separator;
        this.prefix = this.plugin.getPrefix();
        this.vm_prefix = this.getVMPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transferData() {
        Connection vm = this.getVMConnection();
        if (vm != null) {
            int i = 0;
            PreparedStatement statement = null;
            Statement ps = null;
            ResultSet rs = null;
            String queryBeacon = "SELECT * FROM " + this.vm_prefix + "beacons";
            String insertBeacon = "INSERT INTO " + this.prefix + "beacons (`uuid`, `location`, `block_data`) VALUES (?, ?, ?)";
            String querySave = "SELECT * FROM " + this.vm_prefix + "saves";
            String insertSave = "INSERT INTO " + this.prefix + "saves (`uuid`, `save_name`, `world`, `x`, `y`, `z`, `yaw`, `pitch`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            String queryManipulator = "SELECT * FROM " + this.vm_prefix + "manipulator";
            String insertManipulator = "INSERT INTO " + this.prefix + "manipulator (`uuid`, `tachyon_level`) VALUES (?, ?)";
            String queryMessage = "SELECT * FROM " + this.vm_prefix + "messages";
            String insertMessage = "INSERT INTO " + this.prefix + "messages (`uuid_to`, `uuid_from`, `message`, `date`, `read`) VALUES (?, ?, ?, ?, ?)";
            try {
                this.connection.setAutoCommit(false);
                statement = vm.prepareStatement(queryBeacon);
                ps = this.connection.prepareStatement(insertBeacon);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        ps.setString(1, rs.getString("uuid"));
                        ps.setString(2, rs.getString("location"));
                        ps.setString(3, rs.getString("block_type"));
                        ps.addBatch();
                        ++i;
                    }
                }
                if (i > 0) {
                    ps.executeBatch();
                    this.connection.commit();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Transferred " + i + " vortex beacons to database");
                    i = 0;
                }
                statement = vm.prepareStatement(querySave);
                ps = this.connection.prepareStatement(insertSave);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        ps.setString(1, rs.getString("uuid"));
                        ps.setString(2, rs.getString("save_name"));
                        ps.setString(3, rs.getString("world"));
                        ps.setInt(4, rs.getInt("x"));
                        ps.setInt(5, rs.getInt("y"));
                        ps.setInt(6, rs.getInt("z"));
                        ps.setFloat(7, rs.getFloat("yaw"));
                        ps.setFloat(8, rs.getFloat("pitch"));
                        ps.addBatch();
                        ++i;
                    }
                }
                if (i > 0) {
                    ps.executeBatch();
                    this.connection.commit();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Transferred " + i + " vortex saves to database");
                    i = 0;
                }
                statement = vm.prepareStatement(queryManipulator);
                ps = this.connection.prepareStatement(insertManipulator);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        ps.setString(1, rs.getString("uuid"));
                        ps.setInt(2, rs.getInt("tachyon_level"));
                        ps.addBatch();
                        ++i;
                    }
                }
                if (i > 0) {
                    ps.executeBatch();
                    this.connection.commit();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Transferred " + i + " vortex manipulators to database");
                    i = 0;
                }
                statement = vm.prepareStatement(queryMessage);
                ps = this.connection.prepareStatement(insertMessage);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        ps.setString(1, rs.getString("uuid_to"));
                        ps.setString(2, rs.getString("uuid_from"));
                        ps.setString(3, rs.getString("message"));
                        ps.setLong(4, rs.getLong("date"));
                        ps.setInt(5, rs.getInt("read"));
                        ps.addBatch();
                        ++i;
                    }
                }
                if (i > 0) {
                    ps.executeBatch();
                    this.connection.commit();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Transferred " + i + " vortex messages to database");
                }
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("Transfer error for beacons table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    this.connection.setAutoCommit(true);
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing vortex manipulator transfer! " + e.getMessage());
                }
            }
        }
        return true;
    }

    private Connection getVMConnection() {
        if (this.isMySQL) {
            return this.getMySQLConnection();
        }
        return this.getSQLiteConnection();
    }

    public Connection getMySQLConnection() {
        Connection mysql = null;
        if (!this.vm_prefix.equals("NOT_FOUND")) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                String jdbc = "jdbc:mysql://" + this.configuration.getString("storage.mysql.host") + ":" + this.configuration.getString("storage.mysql.port") + "/" + this.configuration.getString("storage.mysql.database") + "?autoReconnect=true";
                if (!this.configuration.getBoolean("storage.mysql.useSSL")) {
                    jdbc = jdbc + "&useSSL=false";
                }
                String user = this.configuration.getString("storage.mysql.user");
                String pass = this.configuration.getString("storage.mysql.password");
                mysql = DriverManager.getConnection(jdbc, user, pass);
                mysql.setAutoCommit(true);
            }
            catch (ClassNotFoundException | SQLException e) {
                this.plugin.debug("Cannot connect the Vortex Manipulator database! " + e.getMessage());
            }
        }
        return mysql;
    }

    public Connection getSQLiteConnection() {
        Connection sqlite = null;
        String path = this.basePath + "TVM.db";
        File file = new File(path);
        if (file.exists()) {
            try {
                Class.forName("org.sqlite.JDBC");
                sqlite = DriverManager.getConnection("jdbc:sqlite:" + path);
                sqlite.setAutoCommit(true);
            }
            catch (ClassNotFoundException | SQLException e) {
                this.plugin.debug("Cannot connect the Vortex Manipulator database! " + e.getMessage());
            }
        }
        return sqlite;
    }

    private String getVMPrefix() {
        File file = new File(this.basePath + "config.yml");
        if (file.exists()) {
            this.configuration = YamlConfiguration.loadConfiguration((File)file);
            this.isMySQL = this.configuration.getString("storage.database").equals("mysql");
            return this.isMySQL ? this.configuration.getString("storage.mysql.prefix") : "";
        }
        return "NOT_FOUND";
    }
}

