/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;

public class ResultSetLightLevel {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private Location location;
    private int c_id;
    private int tardis_id;
    private int type;
    private int level;
    private boolean powered;
    private boolean lightsOn;
    private boolean policeBox;

    public ResultSetLightLevel(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromLocation(String loc) {
        block18: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT " + this.prefix + "controls.*, " + this.prefix + "tardis.powered_on, " + this.prefix + "tardis.lights_on, " + this.prefix + "tardis.chameleon_preset FROM " + this.prefix + "controls, " + this.prefix + "tardis WHERE `type` IN (49, 50, 57) AND location = ? AND " + this.prefix + "controls.tardis_id = " + this.prefix + "tardis.tardis_id";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, loc);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    ChameleonPreset preset;
                    rs.next();
                    this.c_id = rs.getInt("c_id");
                    this.tardis_id = rs.getInt("tardis_id");
                    this.type = rs.getInt("type");
                    this.level = rs.getInt("secondary");
                    this.powered = rs.getBoolean("powered_on");
                    this.lightsOn = rs.getBoolean("lights_on");
                    String[] split = rs.getString("chameleon_preset").split(":");
                    try {
                        preset = ChameleonPreset.valueOf(split[0]);
                    }
                    catch (IllegalArgumentException e) {
                        preset = ChameleonPreset.FACTORY;
                    }
                    this.policeBox = preset.usesArmourStand();
                    break block18;
                }
                boolean split = false;
                return split;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for light level control table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing light level control table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromTypeAndID(int which, int id) {
        block18: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT " + this.prefix + "controls.*, " + this.prefix + "tardis.powered_on, " + this.prefix + "tardis.lights_on, " + this.prefix + "tardis.chameleon_preset FROM " + this.prefix + "controls, " + this.prefix + "tardis WHERE `type` = ? AND " + this.prefix + "controls.tardis_id = ? AND " + this.prefix + "controls.tardis_id = " + this.prefix + "tardis.tardis_id";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, which);
                statement.setInt(2, id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    ChameleonPreset preset;
                    rs.next();
                    this.c_id = rs.getInt("c_id");
                    this.tardis_id = rs.getInt("tardis_id");
                    this.type = rs.getInt("type");
                    this.location = TARDISStaticLocationGetters.getLocationFromBukkitString(rs.getString("location"));
                    this.level = rs.getInt("secondary");
                    this.powered = rs.getBoolean("powered_on");
                    this.lightsOn = rs.getBoolean("lights_on");
                    String[] split = rs.getString("chameleon_preset").split(":");
                    try {
                        preset = ChameleonPreset.valueOf(split[0]);
                    }
                    catch (IllegalArgumentException e) {
                        preset = ChameleonPreset.FACTORY;
                    }
                    this.policeBox = preset.usesArmourStand();
                    break block18;
                }
                boolean split = false;
                return split;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for light level control [type,id] table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing light level control [type,id] table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getControlId() {
        return this.c_id;
    }

    public int getTardis_id() {
        return this.tardis_id;
    }

    public int getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isLightsOn() {
        return this.lightsOn;
    }

    public boolean isPoliceBox() {
        return this.policeBox;
    }
}

