/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.files;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class TARDISSignsUpdater {
    private final TARDIS plugin;
    private final FileConfiguration signs_config;
    private final HashMap<String, List<String>> strings = new HashMap();

    public TARDISSignsUpdater(TARDIS plugin, FileConfiguration signs_config) {
        this.plugin = plugin;
        this.signs_config = signs_config;
        this.strings.put("chameleon", List.of("Chameleon", "Circuit"));
        this.strings.put("info", List.of("Information", "System"));
        this.strings.put("ars", List.of("Architectural", "Reconfiguration", "System"));
        this.strings.put("temporal", List.of("Temporal", "Locator"));
        this.strings.put("terminal", List.of("Destination", "Terminal"));
        this.strings.put("saves", List.of("Saved", "Locations"));
        this.strings.put("control", List.of("Control", "Centre"));
        this.strings.put("keyboard", List.of("Keyboard"));
        this.strings.put("junk", List.of("Destination"));
    }

    public void checkSignsConfig() {
        int i = 0;
        for (Map.Entry<String, List<String>> entry : this.strings.entrySet()) {
            if (this.signs_config.contains(entry.getKey())) continue;
            this.signs_config.set(entry.getKey(), entry.getValue());
            ++i;
        }
        try {
            String signPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "language" + File.separator + "signs.yml";
            this.signs_config.save(new File(signPath));
            if (i > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Added " + i + " new items to signs.yml");
            }
        }
        catch (IOException io) {
            this.plugin.debug("Could not save signs.yml, " + io.getMessage());
        }
    }
}

