/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitDamager;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHomeLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.floodgate.FloodgateColouredBlocks;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISAreaCheck;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateSavesForm {
    private final TARDIS plugin;
    private final String path = "textures/blocks/%s.png";
    private final UUID uuid;
    private final int id;

    public FloodgateSavesForm(TARDIS plugin, UUID uuid, int id) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.id = id;
    }

    public void send() {
        int i = 2;
        HashMap<String, Object> did = new HashMap<String, Object>();
        did.put("tardis_id", this.id);
        ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, did, true);
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("TARDIS Saves Menu");
        builder.button("Home", FormImage.Type.PATH, "textures/blocks/beehive_front.png");
        if (rsd.resultSet()) {
            for (HashMap<String, String> map : rsd.getData()) {
                builder.button(map.get("dest_name") + " ~ " + map.get("dest_id"), FormImage.Type.PATH, String.format("textures/blocks/%s.png", FloodgateColouredBlocks.IMAGES.get(i)));
                ++i;
            }
        }
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        int travel;
        ResultSetTardisArtron rs;
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        Location current = null;
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, this.id);
        if (rsc.resultSet()) {
            current = rsc.getCurrent().location();
        }
        if (!(rs = new ResultSetTardisArtron(this.plugin)).fromID(this.id)) {
            return;
        }
        int level = rs.getArtronLevel();
        if (level < (travel = this.plugin.getArtronConfig().getInt("travel"))) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
            return;
        }
        String dest = response.clickedButton().text();
        String[] split = dest.split(" ~ ");
        if (split.length > 1) {
            int dest_id = TARDISNumberParsers.parseInt(split[1]);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("dest_id", dest_id);
            ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, where, false);
            if (rsd.resultSet()) {
                World w = TARDISAliasResolver.getWorldFromAlias(rsd.getWorld());
                if (w == null) {
                    return;
                }
                Location save_dest = new Location(w, (double)rsd.getX(), (double)rsd.getY(), (double)rsd.getZ());
                if (save_dest != null) {
                    if (rsd.getWorld().startsWith("TARDIS_")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NO_TARDIS");
                        return;
                    }
                    if (!this.plugin.getPluginRespect().getRespect(save_dest, new Parameters(player, Flag.getDefaultFlags()))) {
                        return;
                    }
                    TARDISAreaCheck tac = this.plugin.getTardisArea().isSaveInArea(save_dest);
                    if (tac.isInArea()) {
                        HashMap<String, Object> wheresave = new HashMap<String, Object>();
                        wheresave.put("world", rsd.getWorld());
                        wheresave.put("x", rsd.getX());
                        wheresave.put("y", rsd.getY());
                        wheresave.put("z", rsd.getZ());
                        ResultSetCurrentLocation rsz = new ResultSetCurrentLocation(this.plugin, wheresave);
                        if (rsz.resultSet()) {
                            this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "TARDIS_IN_SPOT", "/tardistravel area [name]", this.plugin);
                            return;
                        }
                        String invisibility = tac.getArea().invisibility();
                        HashMap<String, Object> wheret = new HashMap<String, Object>();
                        wheret.put("tardis_id", this.id);
                        ResultSetTardis resultSetTardis = new ResultSetTardis(this.plugin, wheret, "", false);
                        if (resultSetTardis.resultSet()) {
                            if (invisibility.equals("DENY") && resultSetTardis.getTardis().getPreset().equals((Object)ChameleonPreset.INVISIBLE)) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NO_INVISIBLE");
                                return;
                            }
                            if (!invisibility.equals("ALLOW")) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_FORCE_PRESET", invisibility);
                                HashMap<String, Object> wherei = new HashMap<String, Object>();
                                wherei.put("tardis_id", this.id);
                                HashMap<String, Object> seti = new HashMap<String, Object>();
                                seti.put("chameleon_preset", invisibility);
                                seti.put("adapti_on", 0);
                                this.plugin.getQueryFactory().doSyncUpdate("tardis", seti, wherei);
                            }
                        }
                    }
                    if (!save_dest.equals((Object)current) || this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id)) {
                        if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.materialisation") > 0) {
                            TARDISCircuitChecker tcc = new TARDISCircuitChecker(this.plugin, this.id);
                            tcc.getCircuits();
                            int uses_left = tcc.getMemoryUses();
                            new TARDISCircuitDamager(this.plugin, DiskCircuit.MEMORY, uses_left, this.id, player).damage();
                        }
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        set.put("world", rsd.getWorld());
                        set.put("x", rsd.getX());
                        set.put("y", rsd.getY());
                        set.put("z", rsd.getZ());
                        set.put("direction", rsd.getDirection());
                        set.put("submarine", rsd.isSubmarine() ? 1 : 0);
                        HashMap<String, Object> sett = new HashMap<String, Object>();
                        if (!rsd.getPreset().isEmpty()) {
                            sett.put("chameleon_preset", rsd.getPreset());
                            sett.put("adapti_on", 0);
                            HashMap<String, Object> wheret = new HashMap<String, Object>();
                            wheret.put("tardis_id", this.id);
                            this.plugin.getQueryFactory().doSyncUpdate("tardis", sett, wheret);
                        }
                        HashMap<String, Object> whereid = new HashMap<String, Object>();
                        whereid.put("tardis_id", this.id);
                        this.plugin.getQueryFactory().doSyncUpdate("next", set, whereid);
                        this.plugin.getTrackerKeeper().getHasDestination().put(this.id, new TravelCostAndType(travel, TravelType.SAVE));
                        this.plugin.getTrackerKeeper().getRescue().remove(this.id);
                        this.plugin.getMessenger().sendJoined(player, "DEST_SET_TERMINAL", split[0], !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id));
                        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id)) {
                            new TARDISLand(this.plugin, this.id, player).exitVortex();
                            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.SAVE, this.id));
                        }
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AT_DEST", split[0]);
                    }
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DEST_NOT_VALID", split[0]);
                }
            }
        } else {
            HashMap<String, Object> wherehl = new HashMap<String, Object>();
            wherehl.put("tardis_id", this.id);
            ResultSetHomeLocation rsh = new ResultSetHomeLocation(this.plugin, wherehl);
            if (rsh.resultSet()) {
                Location home = new Location(rsh.getWorld(), (double)rsh.getX(), (double)rsh.getY(), (double)rsh.getZ());
                if (!home.equals((Object)current) || this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id)) {
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("world", rsh.getWorld());
                    set.put("x", rsh.getX());
                    set.put("y", rsh.getY());
                    set.put("z", rsh.getZ());
                    set.put("direction", (Object)rsh.getDirection());
                    set.put("submarine", rsh.isSubmarine() ? 1 : 0);
                    HashMap<String, Object> sett = new HashMap<String, Object>();
                    sett.put("chameleon_preset", rsh.getPreset());
                    sett.put("adapti_on", 0);
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", this.id);
                    this.plugin.getQueryFactory().doSyncUpdate("tardis", sett, wheret);
                    HashMap<String, Object> whereid = new HashMap<String, Object>();
                    wheret.put("tardis_id", this.id);
                    this.plugin.getQueryFactory().doSyncUpdate("next", set, whereid);
                    this.plugin.getTrackerKeeper().getHasDestination().put(this.id, new TravelCostAndType(travel, TravelType.HOME));
                    this.plugin.getTrackerKeeper().getRescue().remove(this.id);
                    this.plugin.getMessenger().sendJoined(player, "DEST_SET_TERMINAL", split[0], !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id));
                    if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id)) {
                        new TARDISLand(this.plugin, this.id, player).exitVortex();
                        this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.HOME, this.id));
                    }
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AT_HOME");
                }
            }
        }
    }
}

