/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetChunks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.Advancement;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.TARDISCondenserData;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomBuilder;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomDirection;
import me.eccentric_nz.TARDIS.rooms.TARDISSeedData;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;

public class TARDISRoomSeeder
implements Listener {
    private final TARDIS plugin;

    public TARDISRoomSeeder(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSeedBlockInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.plugin.getTrackerKeeper().getRoomSeed().containsKey(uuid)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null) {
            Material blockType = block.getType();
            Material inhand = player.getInventory().getItemInMainHand().getType();
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, player.getUniqueId().toString());
            String key = rsp.resultSet() ? (!rsp.getKey().isEmpty() ? rsp.getKey() : this.plugin.getConfig().getString("preferences.key")) : this.plugin.getConfig().getString("preferences.key");
            if (this.plugin.getBuildKeeper().getSeeds().containsKey(blockType) && inhand.equals((Object)Material.getMaterial((String)key))) {
                if (!this.plugin.getUtils().inTARDISWorld(player)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_IN_WORLD");
                    this.plugin.getTrackerKeeper().getRoomSeed().remove(uuid);
                    return;
                }
                Location b = block.getLocation();
                TARDISRoomDirection trd = new TARDISRoomDirection(block);
                trd.getDirection();
                if (!trd.isFound()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLATE_NOT_FOUND");
                    this.plugin.getTrackerKeeper().getRoomSeed().remove(uuid);
                    return;
                }
                if (!trd.isAir()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AIR_NOT_FOUND");
                    this.plugin.getTrackerKeeper().getRoomSeed().remove(uuid);
                    return;
                }
                COMPASS d = trd.getCompass();
                BlockFace facing = trd.getFace();
                TARDISSeedData sd = this.plugin.getTrackerKeeper().getRoomSeed().get(uuid);
                Chunk c = b.getWorld().getChunkAt(block.getRelative(BlockFace.valueOf((String)d.toString()), 4));
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", sd.getId());
                where.put("world", c.getWorld().getName());
                where.put("x", c.getX());
                where.put("z", c.getZ());
                ResultSetChunks rsc = new ResultSetChunks(this.plugin, where, false);
                if (rsc.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_CONSOLE");
                    this.plugin.getTrackerKeeper().getRoomSeed().remove(uuid);
                    return;
                }
                if (sd.hasARS()) {
                    int cx = c.getX();
                    int cy = block.getY();
                    int cz = c.getZ();
                    if (cx >= sd.getMinx() && cx <= sd.getMaxx() && cy >= 48 && cy <= 96 && cz >= sd.getMinz() && cz <= sd.getMaxz()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_USE_ARS");
                        this.plugin.getTrackerKeeper().getRoomSeed().remove(uuid);
                        return;
                    }
                }
                String r = this.plugin.getBuildKeeper().getSeeds().get(blockType);
                if (!sd.getRoom().equals(r)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_SEED_NOT_VALID", this.plugin.getTrackerKeeper().getRoomSeed().get(uuid).getRoom());
                    this.plugin.getTrackerKeeper().getRoomSeed().remove(uuid);
                    return;
                }
                Location l = block.getRelative(facing, 3).getLocation();
                TARDISRoomBuilder builder = new TARDISRoomBuilder(this.plugin, r, l, d, player);
                if (builder.build()) {
                    block.setBlockData(TARDISConstants.AIR);
                    Block doorway = block.getRelative(facing, 2);
                    doorway.setBlockData(TARDISConstants.AIR);
                    doorway.getRelative(BlockFace.UP).setBlockData(TARDISConstants.AIR);
                    this.plugin.getTrackerKeeper().getRoomSeed().remove(uuid);
                    int amount = this.plugin.getRoomsConfig().getInt("rooms." + r + ".cost");
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("uuid", player.getUniqueId().toString());
                    this.plugin.getQueryFactory().alterEnergyLevel("tardis", -amount, set, player);
                    if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks")) {
                        TARDISCondenserData c_data = this.plugin.getGeneralKeeper().getRoomCondenserData().get(uuid);
                        c_data.getBlockIDCount().forEach((key1, value) -> {
                            HashMap<String, Object> wherec = new HashMap<String, Object>();
                            wherec.put("tardis_id", c_data.getTardis_id());
                            wherec.put("block_data", key1);
                            this.plugin.getQueryFactory().alterCondenserBlockCount((int)value, wherec);
                        });
                        this.plugin.getGeneralKeeper().getRoomCondenserData().remove(uuid);
                    }
                    if (this.plugin.getAchievementConfig().getBoolean("rooms.enabled")) {
                        TARDISAchievementFactory taf = new TARDISAchievementFactory(this.plugin, player, Advancement.ROOMS, this.plugin.getBuildKeeper().getSeeds().size());
                        taf.doAchievement(r);
                    }
                }
            }
        }
    }
}

