/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic.actions;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Cocoa;
import org.bukkit.inventory.ItemStack;

public class TARDISSonicReplant
implements Runnable {
    private final TARDIS plugin;
    private final Block block;
    private final Block under;
    private final Material type;
    private final Material air = Material.AIR;
    private final List<Material> dirt = List.of(Material.DIRT, Material.COARSE_DIRT, Material.PODZOL, Material.GRASS_BLOCK);
    private final Material log = Material.JUNGLE_LOG;
    private final Material soil = Material.FARMLAND;
    private final Material soul = Material.SOUL_SAND;
    private final HashMap<BlockFace, BlockFace> c_data = new HashMap();

    public TARDISSonicReplant(TARDIS plugin, Block block, Material type) {
        this.plugin = plugin;
        this.block = block;
        this.under = block.getRelative(BlockFace.DOWN);
        this.type = type;
        this.c_data.put(BlockFace.NORTH, BlockFace.SOUTH);
        this.c_data.put(BlockFace.WEST, BlockFace.EAST);
        this.c_data.put(BlockFace.SOUTH, BlockFace.NORTH);
        this.c_data.put(BlockFace.EAST, BlockFace.WEST);
    }

    @Override
    public void run() {
        switch (this.type) {
            case BEETROOT_SEEDS: {
                if (this.under.getType().equals((Object)this.soil) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.BEETROOTS.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.BEETROOT));
                break;
            }
            case CACTUS: {
                if (this.dirt.contains(this.under.getType()) || Tag.SAND.isTagged((Keyed)this.under.getType()) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.CACTUS.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.CACTUS));
                break;
            }
            case CARROT: {
                if (this.under.getType().equals((Object)this.soil) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.CARROTS.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.CARROT));
                break;
            }
            case COCOA_BEANS: {
                if (this.block.getType().equals((Object)this.air)) {
                    this.plugin.getGeneralKeeper().getFaces().forEach(f -> {
                        if (this.block.getRelative(f).getType().equals((Object)this.log)) {
                            Cocoa cocoa = (Cocoa)Material.COCOA.createBlockData();
                            cocoa.setFacing(this.c_data.get(f));
                            cocoa.setAge(0);
                            this.block.setBlockData((BlockData)cocoa);
                        }
                    });
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.COCOA_BEANS, (int)1));
                break;
            }
            case MELON_SEEDS: {
                if (this.under.getType().equals((Object)this.soil) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.MELON_STEM.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.MELON_SEEDS));
                break;
            }
            case NETHER_WART: {
                if (this.under.getType().equals((Object)this.soul) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.NETHER_WART.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.NETHER_WART));
                break;
            }
            case POTATO: {
                if (this.under.getType().equals((Object)this.soil) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.POTATOES.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.POTATO));
                break;
            }
            case PUMPKIN_SEEDS: {
                if (this.under.getType().equals((Object)this.soil) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.PUMPKIN_STEM.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.PUMPKIN_SEEDS));
                break;
            }
            case SUGAR_CANE: {
                if (this.dirt.contains(this.under.getType()) || Tag.SAND.isTagged((Keyed)this.under.getType()) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.SUGAR_CANE.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.SUGAR_CANE));
                break;
            }
            case WHEAT_SEEDS: {
                if (this.under.getType().equals((Object)this.soil) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.WHEAT.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.WHEAT_SEEDS));
                break;
            }
            case SWEET_BERRIES: {
                if (this.dirt.contains(this.under.getType()) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.SWEET_BERRY_BUSH.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.SWEET_BERRIES));
                break;
            }
            case PITCHER_POD: {
                if (this.under.getType().equals((Object)this.soil) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.PITCHER_CROP.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.PITCHER_PLANT));
                break;
            }
            case TORCHFLOWER: 
            case TORCHFLOWER_SEEDS: {
                if (this.under.getType().equals((Object)this.soil) && this.block.getType().equals((Object)this.air)) {
                    this.block.setBlockData(Material.TORCHFLOWER_CROP.createBlockData());
                    break;
                }
                this.block.getWorld().dropItemNaturally(this.block.getLocation(), ItemStack.of((Material)Material.TORCHFLOWER));
                break;
            }
        }
    }
}

