/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetFlightControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetRepeaters;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.particles.TARDISFirework;
import me.eccentric_nz.TARDIS.sensor.MalfunctionSensor;
import org.bukkit.Location;

public class TARDISMalfunctionExplosion
implements Runnable {
    private final TARDIS plugin;
    private final int id;
    private final long end;
    private final boolean console;
    private boolean started = false;
    private List<Location> locations;
    private int task;

    public TARDISMalfunctionExplosion(TARDIS plugin, int id, long end, boolean console) {
        this.plugin = plugin;
        this.id = id;
        this.end = end;
        this.console = console;
    }

    @Override
    public void run() {
        long time;
        if (!this.started) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", this.id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                if (this.console) {
                    ResultSetFlightControls rsfc = new ResultSetFlightControls(this.plugin, this.id);
                    if (rsfc.resultSet()) {
                        this.locations = rsfc.getLocations();
                    }
                } else {
                    ResultSetRepeaters rsr = new ResultSetRepeaters(this.plugin, tardis.getTardisId(), 0);
                    if (rsr.resultSet()) {
                        this.locations = rsr.getLocations();
                    }
                }
                this.started = true;
            }
        }
        if ((time = System.currentTimeMillis()) > this.end) {
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            new MalfunctionSensor(this.plugin, this.id).toggle();
        } else {
            Location l = this.locations.get(TARDISConstants.RANDOM.nextInt(4));
            TARDISFirework.randomize().displayEffects(this.plugin, l.add(0.5, 0.5, 0.5));
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

