/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravelledTo;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.protection.TARDISChunkyChecker;
import me.eccentric_nz.TARDIS.utility.protection.TARDISGriefPreventionChecker;
import me.eccentric_nz.TARDIS.utility.protection.TARDISTownyChecker;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TARDISPluginRespect {
    private final TARDIS plugin;
    private TARDISTownyChecker townyChecker;
    private TARDISGriefPreventionChecker griefPreventionChecker;
    private TARDISChunkyChecker chunkyBorderCheck;
    private boolean townyOnServer = false;
    private boolean griefPreventionOnServer = false;
    private boolean chunkyBorderOnServer = false;

    public TARDISPluginRespect(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean getRespect(Location location, Parameters flag) {
        WorldBorder wb;
        boolean bool = true;
        if (this.plugin.getConfig().getBoolean("allow.admin_bypass") && flag.getPlayer() != null && flag.getPlayer().hasPermission("tardis.admin")) {
            return true;
        }
        if (this.plugin.getConfig().getBoolean("travel.per_world_perms")) {
            String perm = location.getWorld().getName();
            if (!TARDISPermission.hasPermission(flag.getPlayer(), "tardis.travel." + perm)) {
                if (flag.messagePlayer()) {
                    this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "TRAVEL_NO_PERM_WORLD", perm);
                }
                bool = false;
            }
        }
        if (flag.permsNether() && location.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            if (!this.plugin.getConfig().getBoolean("travel.nether")) {
                if (flag.messagePlayer()) {
                    this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "TRAVEL_DISABLED", "Nether");
                }
                bool = false;
            }
            if (!TARDISPermission.hasPermission(flag.getPlayer(), "tardis.nether")) {
                if (flag.messagePlayer()) {
                    this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "NO_PERM_TRAVEL", "Nether");
                }
                bool = false;
            }
            if (this.plugin.getConfig().getBoolean("travel.allow_nether_after_visit") && !new ResultSetTravelledTo(this.plugin).resultSet(flag.getPlayer().getUniqueId().toString(), "NETHER")) {
                if (flag.messagePlayer()) {
                    this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "TRAVEL_NOT_VISITED", "Nether");
                }
                bool = false;
            }
        }
        if (flag.permsTheEnd() && location.getWorld().getEnvironment().equals((Object)World.Environment.THE_END)) {
            if (!this.plugin.getConfig().getBoolean("travel.the_end")) {
                if (flag.messagePlayer()) {
                    this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "TRAVEL_DISABLED", "End");
                }
                bool = false;
            }
            if (!TARDISPermission.hasPermission(flag.getPlayer(), "tardis.end")) {
                if (flag.messagePlayer()) {
                    this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "NO_PERM_TRAVEL", "End");
                }
                bool = false;
            }
            if (this.plugin.getConfig().getBoolean("travel.allow_end_after_visit") && !new ResultSetTravelledTo(this.plugin).resultSet(flag.getPlayer().getUniqueId().toString(), "THE_END")) {
                if (flag.messagePlayer()) {
                    this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "TRAVEL_NOT_VISITED", "End");
                }
                bool = false;
            }
        }
        if (flag.respectWorldguard() && this.plugin.isWorldGuardOnServer() && !this.plugin.getWorldGuardUtils().canLand(flag.getPlayer(), location)) {
            if (flag.messagePlayer()) {
                this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "WORLDGUARD");
            }
            bool = false;
        }
        if (flag.respectTowny() && this.townyOnServer && !this.plugin.getConfig().getString("preferences.respect_towny").equals("none") && !this.townyChecker.checkTowny(flag.getPlayer(), location)) {
            if (flag.messagePlayer()) {
                this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "TOWNY");
            }
            bool = false;
        }
        if (flag.repectWorldBorder() && !(wb = location.getWorld().getWorldBorder()).isInside(location)) {
            if (flag.messagePlayer()) {
                this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "WORLDBORDER");
            }
            bool = false;
        }
        if (flag.respectChunkyBorder() && this.chunkyBorderOnServer && this.plugin.getConfig().getBoolean("preferences.respect_chunky_border") && this.chunkyBorderCheck.isOutsideBorder(flag.getPlayer(), location)) {
            if (flag.messagePlayer()) {
                this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "CHUNKYBORDER");
            }
            bool = false;
        }
        if (flag.respectGreifPrevention() && this.griefPreventionOnServer && this.plugin.getConfig().getBoolean("preferences.respect_grief_prevention") && this.griefPreventionChecker.isInClaim(flag.getPlayer(), location)) {
            if (flag.messagePlayer()) {
                this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "GRIEFPREVENTION");
            }
            bool = false;
        }
        if (flag.permsArea() && this.plugin.getTardisArea().areaCheckLocPlayer(flag.getPlayer(), location)) {
            if (flag.messagePlayer()) {
                String area_name;
                String area_perm = this.plugin.getTrackerKeeper().getPerm().get(flag.getPlayer().getUniqueId());
                if (area_perm.equals(area_name = "tardis.area." + this.plugin.getConfig().getString("creation.area"))) {
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)flag.getPlayer(), "TARDIS_SET_HOME", "/tardis home", this.plugin);
                } else {
                    this.plugin.getMessenger().send((CommandSender)flag.getPlayer(), TardisModule.TARDIS, "TRAVEL_NO_PERM", area_perm);
                }
            }
            this.plugin.getTrackerKeeper().getPerm().remove(flag.getPlayer().getUniqueId());
            bool = false;
        }
        return bool;
    }

    public void loadTowny() {
        if (this.plugin.getPM().getPlugin("Towny") != null) {
            this.townyOnServer = true;
            this.townyChecker = new TARDISTownyChecker(this.plugin);
        }
    }

    public void loadGriefPrevention() {
        if (this.plugin.getPM().getPlugin("GriefPrevention") != null) {
            this.plugin.debug("Hooking into GriefPrevention!");
            this.griefPreventionOnServer = true;
            this.griefPreventionChecker = new TARDISGriefPreventionChecker(this.plugin);
        }
    }

    public void loadChunkyBorder() {
        if (this.plugin.getPM().getPlugin("ChunkyBorder") != null) {
            this.plugin.debug("Hooking into ChunkyBorder!");
            this.chunkyBorderOnServer = true;
            this.chunkyBorderCheck = new TARDISChunkyChecker(this.plugin);
        }
    }

    public void checkWorldGuardEntry() {
        if (this.plugin.isWorldGuardOnServer()) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getWorldGuardUtils().checkEntryFlags(), 100L);
        }
    }

    TARDISTownyChecker getTownyChecker() {
        return this.townyChecker;
    }

    TARDISGriefPreventionChecker getGriefPreventionChecker() {
        return this.griefPreventionChecker;
    }

    public TARDISChunkyChecker getChunkyBorderCheck() {
        return this.chunkyBorderCheck;
    }

    boolean isTownyOnServer() {
        return this.townyOnServer;
    }

    boolean isGriefPreventionOnServer() {
        return this.griefPreventionOnServer;
    }

    public boolean isChunkyBorderOnServer() {
        return this.chunkyBorderOnServer;
    }
}

