/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.universaltranslator;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class LingvaTranslate {
    private static final List<String> domains = List.of("lingva.lunar.icu", "translate.projectsegfau.lt", "translate.dr460nf1r3.org", "translate.plausibility.cloud", "lingva.ml");
    private final TARDIS plugin;
    private final String from;
    private final String to;
    private final String message;
    private String translated;

    public LingvaTranslate(TARDIS plugin, String from, String to, String message) {
        this.plugin = plugin;
        this.from = from;
        this.to = to;
        this.message = message;
    }

    private static boolean pingURL(String url) {
        try {
            HttpURLConnection connection = (HttpURLConnection)URI.create(url).toURL().openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (IOException exception) {
            return false;
        }
    }

    public void fetchAsync(TranslateCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            boolean hasResult = this.fetch();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onDone(hasResult, this));
        });
    }

    public boolean fetch() {
        try {
            String encoded = this.message.replace(" ", "%20");
            for (String host : domains) {
                HttpResponse<String> response;
                if (!LingvaTranslate.pingURL("http://" + host)) continue;
                URI uri = URI.create("https://" + host + "/api/v1/" + this.from + "/" + this.to + "/" + encoded);
                try (HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();){
                    HttpRequest request = HttpRequest.newBuilder().GET().uri(uri).header("User-Agent", "TARDISPlugin").build();
                    response = client.send(request, HttpResponse.BodyHandlers.ofString());
                }
                JsonElement root = JsonParser.parseString((String)response.body());
                this.translated = root.getAsJsonObject().get("translation").getAsString();
                return true;
            }
        }
        catch (Exception ex) {
            this.plugin.debug("Failed to fetch a translation from Lingva hosts" + ex.getMessage());
        }
        this.translated = "Translation failed :(";
        return false;
    }

    public String getTranslated() {
        return this.translated;
    }

    public static interface TranslateCallback {
        public void onDone(boolean var1, LingvaTranslate var2);
    }
}

