/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.Advancement;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardischemistry.block.Painting;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class TARDISChecker {
    private final TARDIS plugin;
    private final Set<String> broken = new HashSet<String>();

    public TARDISChecker(TARDIS plugin) {
        this.plugin = plugin;
        this.broken.add("aorta.json");
        this.broken.add("chemistry.json");
        this.broken.add("lava.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String filename, File file) {
        InputStream in = null;
        try {
            in = TARDIS.plugin.getResource(filename);
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            try {
                int len;
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            catch (IOException io) {
                TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.SEVERE, "Checker: Could not save the file (" + String.valueOf(file) + ").");
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.SEVERE, "Checker: Could not close the output stream.");
                }
            }
        }
        catch (FileNotFoundException e) {
            TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.SEVERE, "Checker: File not found: " + filename);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.SEVERE, "Checker: Could not close the input stream.");
                }
            }
        }
    }

    public void checkDataPack() {
        File placeable;
        String dataPacksMeta;
        File mcmeta;
        File paintingsDir;
        String dataPacksMinecraft;
        File placeableDir;
        File container = this.plugin.getServer().getWorldContainer();
        String s_world = ((World)this.plugin.getServer().getWorlds().getFirst()).getName();
        String dataPacksTardis = container.getAbsolutePath() + File.separator + s_world + File.separator + "datapacks" + File.separator + "tardis" + File.separator + "data" + File.separator + "tardis" + File.separator;
        String dataPacksAdvancement = dataPacksTardis + "advancements";
        File tardisOldDir = new File(dataPacksAdvancement);
        boolean update = false;
        if (tardisOldDir.exists()) {
            try {
                MoreFiles.deleteRecursively((Path)tardisOldDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
                update = true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!(placeableDir = new File(dataPacksMinecraft = container.getAbsolutePath() + File.separator + s_world + File.separator + "datapacks" + File.separator + "tardis" + File.separator + "data" + File.separator + "minecraft" + File.separator + "tags" + File.separator + "painting_variant" + File.separator)).exists()) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_DIRECTORIES", "%s"), "placeable"));
            placeableDir.mkdirs();
        }
        dataPacksAdvancement = dataPacksTardis + "advancement";
        String dataPacksPaintings = dataPacksTardis + "painting_variant";
        File advancementDir = new File(dataPacksAdvancement);
        if (!advancementDir.exists()) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_DIRECTORIES", "%s"), "advancements"));
            advancementDir.mkdirs();
        }
        if (!(paintingsDir = new File(dataPacksPaintings)).exists()) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_DIRECTORIES", "%s"), "painting variants"));
            paintingsDir.mkdirs();
        }
        if (!(mcmeta = new File(dataPacksMeta = container.getAbsolutePath() + File.separator + s_world + File.separator + "datapacks" + File.separator + "tardis", "pack.mcmeta")).exists() || update) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_NOT_FOUND", "%s"), "pack.mcmeta", "datapack"));
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_COPYING", "%s"), "datapack", "pack.mcmeta"));
            TARDISChecker.copy("pack.mcmeta", mcmeta);
        }
        Gson gson = new GsonBuilder().create();
        try {
            Map map = (Map)gson.fromJson((Reader)new FileReader(mcmeta), Map.class);
            for (Map.Entry entry : map.entrySet()) {
                Object object;
                if (!entry.getKey().equals("pack") || !((object = entry.getValue()) instanceof Map)) continue;
                Map values = (Map)object;
                object = values.entrySet().iterator();
                while (object.hasNext()) {
                    Double d;
                    Map.Entry data = (Map.Entry)object.next();
                    if (!data.getKey().equals("pack_format") || !((d = (Double)data.getValue()) < 81.0)) continue;
                    HashMap mcmap = new HashMap();
                    HashMap<String, Object> pack = new HashMap<String, Object>();
                    pack.put("description", "Data pack for the TARDIS plugin");
                    pack.put("pack_format", 81);
                    mcmap.put("pack", pack);
                    FileWriter writer = new FileWriter(mcmeta);
                    gson.toJson(mcmap, (Appendable)writer);
                    writer.close();
                }
            }
        }
        catch (IOException map) {
            // empty catch block
        }
        if (!(placeable = new File(dataPacksMinecraft, "placeable.json")).exists()) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_NOT_FOUND", "%s"), "placeable.json", "painting variant"));
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_COPYING", "%s"), "painting variant", "placeable.json"));
            TARDISChecker.copy("painting_variant/placeable.json", placeable);
        }
        this.write(dataPacksTardis);
    }

    private void write(String rootFolder) {
        File jfile;
        String json;
        for (Advancement advancement : Advancement.values()) {
            json = advancement.getConfigName() + ".json";
            jfile = new File(rootFolder + "advancement", json);
            if (!jfile.exists()) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_NOT_FOUND", "%s"), json, "advancement"));
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_COPYING", "%s, %s"), "advancement", json));
                TARDISChecker.copy("advancement/" + json, jfile);
                continue;
            }
            if (advancement != Advancement.ROOT || this.plugin.getConfig().getBoolean("conversions.adv_root", false)) continue;
            try {
                JsonReader reader = new JsonReader((Reader)new FileReader(jfile));
                JsonObject root = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
                JsonObject display = root.get("display").getAsJsonObject();
                String background = display.get("background").getAsString();
                if (!background.contains(".png")) continue;
                TARDISChecker.copy("advancement/" + json, jfile);
                this.plugin.getConfig().set("conversions.adv_root", (Object)true);
                this.plugin.saveConfig();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        for (Enum enum_ : Painting.values()) {
            json = ((Painting)enum_).getName() + ".json";
            jfile = new File(rootFolder + "painting_variant", json);
            if (!jfile.exists()) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_NOT_FOUND", "%s"), json, "painting variant"));
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, String.format(this.plugin.getLanguage().getString("DATAPACK_COPYING", "%s"), "painting variant", json));
                TARDISChecker.copy("painting_variant/" + json, jfile);
            } else if (!this.plugin.getConfig().getBoolean("conversions.paintings") && this.broken.contains(json)) {
                TARDISChecker.copy("painting_variant/" + json, jfile);
            } else if (!this.plugin.getConfig().getBoolean("conversions.exploding") && enum_ == Painting.EXPLODING_TARDIS) {
                this.plugin.debug("Fixing exploding TARDIS painting");
                TARDISChecker.copy("painting_variant/" + json, jfile);
                this.plugin.getConfig().set("conversions.exploding", (Object)true);
            }
            this.plugin.saveConfig();
        }
    }
}

