/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.database;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.tardisvortexmanipulator.storage.TVMMessage;

public class TVMResultSetInbox {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String where;
    private final int start;
    private final int limit;
    private final List<TVMMessage> mail = new ArrayList<TVMMessage>();
    private final String prefix;

    public TVMResultSetInbox(TARDIS plugin, String where, int start, int limit) {
        this.plugin = plugin;
        this.where = where;
        this.start = start;
        this.limit = limit;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = String.format("SELECT * FROM " + this.prefix + "messages WHERE uuid_to = ? ORDER BY read, date DESC LIMIT %d, %d", this.start, this.start + this.limit);
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.where);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        TVMMessage tvmm = new TVMMessage();
                        tvmm.setId(rs.getInt("message_id"));
                        tvmm.setWho(UUID.fromString(rs.getString("uuid_from")));
                        tvmm.setMessage(rs.getString("message"));
                        tvmm.setDate(this.getFormattedDate(rs.getLong("date")));
                        tvmm.setRead(rs.getBoolean("read"));
                        this.mail.add(tvmm);
                    }
                    break block17;
                }
                boolean tvmm = false;
                return tvmm;
            }
            catch (SQLException e) {
                this.plugin.debug("Inbox error for messages table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing messages table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    private String getFormattedDate(long millis) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.plugin.getVortexConfig().getString("date_format"));
        Date theDate = new Date(millis);
        return sdf.format(theDate);
    }

    public List<TVMMessage> getMail() {
        return this.mail;
    }
}

