/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.RootCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TARDISQuestionTabComplete
extends TARDISCompleter
implements TabCompleter {
    private final TARDIS plugin;
    private final ImmutableList<String> ROOT_SUBS;
    private final List<String> notThese = List.of("aliases", "description", "usage", "permission", "permission-message");

    public TARDISQuestionTabComplete(TARDIS plugin) {
        this.plugin = plugin;
        ArrayList<String> roots = new ArrayList<String>();
        for (RootCommand rc : RootCommand.values()) {
            roots.add(rc.toString());
        }
        this.ROOT_SUBS = ImmutableList.copyOf(roots);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
        }
        if (args.length == 2) {
            String sub = args[0];
            return this.partial(lastArg, (Collection<String>)this.removeUnwanted(this.plugin.getGeneralKeeper().getPluginYAML().getConfigurationSection("commands." + sub).getKeys(false)));
        }
        return ImmutableList.of();
    }

    private ImmutableList<String> removeUnwanted(Set<String> set) {
        this.notThese.forEach(set::remove);
        return ImmutableList.copyOf(set);
    }
}

