/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.ReplacedBlock;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ResultSetBlocks {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final boolean multiple;
    private final List<ReplacedBlock> data = new ArrayList<ReplacedBlock>();
    private final String prefix;
    private ReplacedBlock replacedBlock;

    public ResultSetBlocks(TARDIS plugin, HashMap<String, Object> where, boolean multiple) {
        this.plugin = plugin;
        this.where = where;
        this.multiple = multiple;
        this.prefix = this.plugin.getPrefix();
    }

    public void resultSetAsync(ResultSetBlocksCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            boolean hasResult = this.resultSet();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onDone(hasResult, this));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block24: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "blocks" + (String)wheres;
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    int s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        String str = rs.getString("location");
                        String bd = rs.getString("data");
                        if (rs.wasNull() || bd.equals("0")) {
                            bd = "minecraft:air";
                        }
                        if (bd.contains("grass_path")) {
                            bd = "minecraft:dirt_path";
                        }
                        this.replacedBlock = new ReplacedBlock(rs.getInt("b_id"), rs.getInt("tardis_id"), TARDISStaticLocationGetters.getLocationFromBukkitString(str), str, this.plugin.getServer().createBlockData(bd), rs.getInt("police_box"));
                        if (!this.multiple) continue;
                        this.data.add(this.replacedBlock);
                    }
                    break block24;
                }
                boolean str = false;
                return str;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for blocks table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing blocks table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public ReplacedBlock getReplacedBlock() {
        return this.replacedBlock;
    }

    public List<ReplacedBlock> getData() {
        return this.data;
    }

    public static interface ResultSetBlocksCallback {
        public void onDone(boolean var1, ResultSetBlocks var2);
    }
}

