/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.headless_monks;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class HeadlessShootRunnable
implements Runnable {
    private final Entity monk;
    private final Entity target;
    private final boolean fireball;
    private int taskID;

    public HeadlessShootRunnable(Entity monk, Entity target, boolean fireball) {
        this.monk = monk;
        this.target = target;
        this.fireball = fireball;
    }

    @Override
    public void run() {
        if (this.monk.isDead() || ((Monster)this.monk).getTarget() == null) {
            Bukkit.getScheduler().cancelTask(this.taskID);
            return;
        }
        Vector direction = this.target.getLocation().toVector().subtract(this.monk.getLocation().toVector());
        direction.normalize();
        Vector bulletVelocity = direction.multiply(2.0);
        if (this.fireball) {
            ((LivingEntity)this.monk).launchProjectile(SmallFireball.class, bulletVelocity);
        } else {
            Snowball snowball = (Snowball)((LivingEntity)this.monk).launchProjectile(Snowball.class, bulletVelocity);
            snowball.setItem(ItemStack.of((Material)Material.FIRE_CHARGE, (int)1));
        }
    }

    public void setTaskID(int taskID) {
        this.taskID = taskID;
    }
}

