/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.Time;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TARDISTimeCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final ImmutableList<String> ROOT_SUBS = ImmutableList.of((Object)"day", (Object)"morning", (Object)"noon", (Object)"night", (Object)"midnight", (Object)"1AM", (Object)"2AM", (Object)"3AM", (Object)"4AM", (Object)"5AM", (Object)"6AM", (Object)"7AM", (Object[])new String[]{"8AM", "9AM", "10AM", "11AM", "12AM", "1PM", "2PM", "3PM", "4PM", "5PM", "6PM", "7PM", "8PM", "9PM", "10PM", "11PM", "12PM"});

    public TARDISTimeCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardistime")) {
            if (args.length < 1) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return true;
            }
            if (sender instanceof Player) {
                long ticks;
                Time time;
                Player player = (Player)sender;
                if (!player.hasPermission("tardis.admin")) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                    return true;
                }
                Location location = player.getLocation();
                World world = location.getWorld();
                if (this.plugin.getUtils().inTARDISWorld(player)) {
                    int id = this.plugin.getTardisAPI().getIdOfTARDISPlayerIsIn(player);
                    ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                    if (rsc.resultSet()) {
                        world = rsc.getCurrent().location().getWorld();
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TIME_TARDIS");
                        return true;
                    }
                }
                if ((time = Time.getByName().get(args[0].toUpperCase(Locale.ROOT))) != null) {
                    ticks = time.getTicks();
                } else {
                    try {
                        ticks = Long.parseLong(args[0]);
                    }
                    catch (NumberFormatException nfe) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TIME_FORMAT");
                        return true;
                    }
                }
                world.setTime(ticks);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TIME_SET", String.format("%s", ticks), world.getName());
            } else {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length <= 1) {
            return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
        }
        return ImmutableList.of();
    }
}

