/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetVault;
import me.eccentric_nz.TARDIS.enumeration.SmelterChest;
import me.eccentric_nz.TARDIS.sonic.TARDISSonicSorterListener;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Container;
import org.bukkit.block.data.type.Chest;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TARDISVaultListener
implements Listener {
    private final TARDIS plugin;
    private final Set<Material> containers = new HashSet<Material>();
    private Block leftover = null;

    public TARDISVaultListener(TARDIS plugin) {
        this.plugin = plugin;
        this.containers.add(Material.BARREL);
        this.containers.add(Material.CHEST);
        this.containers.add(Material.TRAPPED_CHEST);
        this.containers.addAll(Tag.SHULKER_BOXES.getValues());
        this.containers.addAll(Tag.COPPER_CHESTS.getValues());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onVaultDropChestClose(InventoryCloseEvent event) {
        Inventory inv = event.getInventory();
        InventoryHolder holder = inv.getHolder(false);
        if (holder instanceof Container) {
            Container container = (Container)holder;
            Location l = container.getLocation();
            if (!this.plugin.getUtils().inTARDISWorld(l)) {
                return;
            }
            ResultSetVault rs = new ResultSetVault(this.plugin);
            String loc = l.toString();
            if (!rs.fromLocationAndChestType(loc, SmelterChest.DROP)) {
                return;
            }
            HashSet<String> containerLocations = new HashSet<String>();
            containerLocations.add(loc);
            ResultSetVault rsl = new ResultSetVault(this.plugin);
            if (rsl.fromIdAndChestType(rs.getTardis_id(), SmelterChest.UNSORTED)) {
                containerLocations.add(rsl.getLocation());
                Location left = TARDISStaticLocationGetters.getLocationFromBukkitString(rsl.getLocation());
                if (left != null) {
                    this.leftover = left.getBlock();
                }
            }
            TARDISSonicSorterListener.sortInventory(inv);
            World w = container.getWorld();
            int sx = rs.getX();
            int sy = rs.getY();
            int sz = rs.getZ();
            for (int y = sy; y < sy + 16; ++y) {
                for (int x = sx; x < sx + 16; ++x) {
                    for (int z = sz; z < sz + 16; ++z) {
                        Block b = w.getBlockAt(x, y, z);
                        String blocation = b.getLocation().toString();
                        if (containerLocations.contains(blocation) || !this.containers.contains(b.getType())) continue;
                        Container c = (Container)b.getState();
                        if (b.getType().equals((Object)Material.CHEST) || b.getType().equals((Object)Material.TRAPPED_CHEST)) {
                            Chest chestdata = (Chest)b.getBlockData();
                            Chest.Type chestType = chestdata.getType();
                            if (chestType.equals((Object)Chest.Type.LEFT)) {
                                switch (chestdata.getFacing()) {
                                    case WEST: {
                                        containerLocations.add(b.getRelative(BlockFace.NORTH).getLocation().toString());
                                        break;
                                    }
                                    case SOUTH: {
                                        containerLocations.add(b.getRelative(BlockFace.WEST).getLocation().toString());
                                        break;
                                    }
                                    case EAST: {
                                        containerLocations.add(b.getRelative(BlockFace.SOUTH).getLocation().toString());
                                        break;
                                    }
                                    default: {
                                        containerLocations.add(b.getRelative(BlockFace.EAST).getLocation().toString());
                                        break;
                                    }
                                }
                            } else if (chestType.equals((Object)Chest.Type.RIGHT)) {
                                switch (chestdata.getFacing()) {
                                    case WEST: {
                                        containerLocations.add(b.getRelative(BlockFace.SOUTH).getLocation().toString());
                                        break;
                                    }
                                    case SOUTH: {
                                        containerLocations.add(b.getRelative(BlockFace.EAST).getLocation().toString());
                                        break;
                                    }
                                    case EAST: {
                                        containerLocations.add(b.getRelative(BlockFace.NORTH).getLocation().toString());
                                        break;
                                    }
                                    default: {
                                        containerLocations.add(b.getRelative(BlockFace.WEST).getLocation().toString());
                                    }
                                }
                            }
                        }
                        containerLocations.add(blocation);
                        Inventory cinv = c.getInventory();
                        if (cinv.firstEmpty() == -1) continue;
                        ItemStack[] cc = cinv.getContents();
                        ArrayList<Material> mats = new ArrayList<Material>();
                        for (ItemStack is : cc) {
                            Material m2;
                            if (is == null || mats.contains(m2 = is.getType())) continue;
                            mats.add(m2);
                        }
                        mats.forEach(m -> {
                            int slot = inv.first(m);
                            while (slot != -1 && cinv.firstEmpty() != -1) {
                                ItemStack get = inv.getItem(slot);
                                inv.setItem(slot, null);
                                cinv.setItem(cinv.firstEmpty(), get);
                                TARDISSonicSorterListener.sortInventory(cinv);
                                slot = inv.first(m);
                            }
                        });
                    }
                }
            }
            if (this.leftover != null) {
                ItemStack[] stacks = (ItemStack[])Arrays.stream(holder.getInventory().getContents()).filter(Objects::nonNull).toArray(ItemStack[]::new);
                Container c = (Container)this.leftover.getState();
                HashMap cannotFit = c.getInventory().addItem(stacks);
                holder.getInventory().clear();
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    ItemStack[] remainingItems = cannotFit.values().toArray(new ItemStack[0]);
                    if (remainingItems.length > 0) {
                        holder.getInventory().addItem(remainingItems);
                    }
                }, 2L);
            }
        }
    }
}

