/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.monitor;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetChunks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.monitor.MonitorUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class MonitorSnapshot {
    private final TARDIS plugin;

    public MonitorSnapshot(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static void loadChunks(TARDIS plugin, Location doorBottom, boolean in, COMPASS d, int id, int distance) {
        block15: {
            block14: {
                if (!in) break block14;
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                ResultSetChunks rsc = new ResultSetChunks(plugin, where, true);
                if (!rsc.resultSet()) break block15;
                for (HashMap<String, String> map : rsc.getData()) {
                    int x = TARDISNumberParsers.parseInt(map.get("x"));
                    int z = TARDISNumberParsers.parseInt(map.get("z"));
                    Chunk chunk = doorBottom.getWorld().getChunkAt(x, z);
                    while (!chunk.isLoaded()) {
                        chunk.load();
                    }
                }
                break block15;
            }
            int dx = 0;
            int dz = 0;
            boolean bx = false;
            boolean bz = false;
            switch (d) {
                case NORTH: {
                    dz = 1;
                    bx = true;
                    break;
                }
                case EAST: {
                    dx = -1;
                    bz = true;
                    break;
                }
                case SOUTH: {
                    dz = -1;
                    bx = true;
                    break;
                }
                default: {
                    dx = 1;
                    bz = true;
                }
            }
            Chunk chunk = doorBottom.getChunk();
            while (!chunk.isLoaded()) {
                chunk.load();
            }
            int cx = chunk.getX();
            int cz = chunk.getZ();
            int side = 0;
            for (int i = 1; i < distance / 16 + 1; ++i) {
                Chunk next = doorBottom.getWorld().getChunkAt(cx += dx, cz += dz);
                while (!next.isLoaded()) {
                    next.load();
                }
                for (int j = -side; j <= side; ++j) {
                    if (bx) {
                        next = doorBottom.getWorld().getChunkAt(cx + j, cz);
                    }
                    if (bz) {
                        next = doorBottom.getWorld().getChunkAt(cx, cz + j);
                    }
                    while (!next.isLoaded()) {
                        next.load();
                    }
                }
                if (i % 2 != 0) continue;
                side += 2;
            }
        }
    }

    public void get(boolean in, Player player) {
        int which = in ? 1 : 0;
        int distance = in ? 48 : 128;
        ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
        if (rst.fromUUID(player.getUniqueId().toString())) {
            int id = rst.getTardisId();
            HashMap<String, Object> whered = new HashMap<String, Object>();
            whered.put("tardis_id", id);
            whered.put("door_type", which);
            ResultSetDoors rsd = new ResultSetDoors(this.plugin, whered, false);
            if (rsd.resultSet()) {
                COMPASS d = rsd.getDoor_direction();
                Location doorBottom = TARDISStaticLocationGetters.getLocationFromDB(rsd.getDoor_location());
                doorBottom.add(0.0, (double)1.6f, 0.0);
                int getx = doorBottom.getBlockX();
                int getz = doorBottom.getBlockZ();
                float yaw = switch (d) {
                    case COMPASS.NORTH -> {
                        doorBottom.setX((double)getx + 0.5);
                        doorBottom.setZ((double)getz - 0.5);
                        yield in ? 180.05f : 0.05f;
                    }
                    case COMPASS.EAST -> {
                        doorBottom.setX((double)getx + 1.5);
                        doorBottom.setZ((double)getz + 0.5);
                        yield in ? -90.05f : 90.05f;
                    }
                    case COMPASS.SOUTH -> {
                        doorBottom.setX((double)getx + 0.5);
                        doorBottom.setZ((double)getz + 1.5);
                        yield in ? 0.05f : 180.05f;
                    }
                    default -> {
                        doorBottom.setX((double)getx - 0.5);
                        doorBottom.setZ((double)getz + 0.5);
                        yield in ? 90.05f : -90.05f;
                    }
                };
                doorBottom.setPitch(25.0f);
                doorBottom.setYaw(yaw);
                Location doorTop = doorBottom.clone();
                doorTop.setPitch(-25.5f);
                MonitorSnapshot.loadChunks(this.plugin, doorBottom, in, d, id, distance);
                if (player.getInventory().getItemInMainHand().getType().equals((Object)Material.FILLED_MAP) && player.getInventory().getItemInOffHand().getType().equals((Object)Material.FILLED_MAP)) {
                    MonitorUtils.updateSnapshot(doorTop, distance, player.getInventory().getItemInMainHand());
                    MonitorUtils.updateSnapshot(doorBottom, distance, player.getInventory().getItemInOffHand());
                } else {
                    MonitorUtils.createSnapshot(doorBottom, player, distance);
                    MonitorUtils.createSnapshot(doorTop, player, distance);
                }
            }
        }
    }
}

