/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.portal;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.ConsoleSize;
import me.eccentric_nz.TARDIS.portal.CastRotorData;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.util.Vector;

public class Capture {
    private ItemFrame rotorFrame;
    private Vector offset;

    public BlockData[][][] captureInterior(Location location, int distance, UUID rotor, ConsoleSize consoleSize) {
        int ix;
        int iy;
        int iz;
        int n = iz = TARDIS.plugin.getConfig().getBoolean("policebox.view_interior_uses_console_size") ? consoleSize.getCastDistance() : 16;
        if (distance == 9) {
            iy = 5;
            ix = 5;
        } else if (distance == 4) {
            iy = 6;
            ix = 7;
        } else {
            iy = 7;
            ix = 9;
        }
        BlockData[][][] capture = new BlockData[iy][ix][iz];
        int bx = -ix / 2;
        int bz = 1;
        World world = location.getWorld();
        int startX = location.getBlockX() + bx;
        int startY = location.getBlockY() - 1;
        int startZ = location.getBlockZ() + bz;
        for (int y = 0; y < iy; ++y) {
            for (int x = 0; x < ix; ++x) {
                for (int z = 0; z < iz; ++z) {
                    int xx = startX + x;
                    int yy = startY + y;
                    int zz = startZ + z;
                    if ((z == 0 || z == 1) && (x == 0 || x == ix - 1) || z == 0 && (x == 1 || x == ix - 2)) continue;
                    capture[y][x][z] = world.getBlockAt(xx, yy, zz).getBlockData();
                }
            }
        }
        if (rotor != null) {
            for (Entity e : world.getEntities()) {
                if (!e.getUniqueId().equals(rotor)) continue;
                this.rotorFrame = (ItemFrame)e;
                if (this.rotorFrame == null) continue;
                Location f = this.rotorFrame.getLocation();
                this.offset = new Vector(f.getBlockX() - location.getBlockX(), f.getBlockY() - location.getBlockY(), f.getBlockZ() - location.getBlockZ());
            }
        }
        return capture;
    }

    public CastRotorData getRotorData() {
        return new CastRotorData(this.rotorFrame, this.offset);
    }
}

