/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetFarming;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHappy;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisTimeLordName;
import me.eccentric_nz.TARDIS.enumeration.Room;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.UseClay;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.rooms.TARDISPainting;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomData;
import me.eccentric_nz.TARDIS.rooms.eye.EyeOfHarmonyParticles;
import me.eccentric_nz.TARDIS.rooms.library.LibraryCatalogue;
import me.eccentric_nz.TARDIS.schematic.getters.DataPackPainting;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISBannerSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISItemDisplaySetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISItemFrameSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISPotSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISSignSetter;
import me.eccentric_nz.TARDIS.utility.TARDISBannerData;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import me.eccentric_nz.tardischunkgenerator.custombiome.BiomeHelper;
import net.kyori.adventure.text.Component;
import org.bukkit.Art;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.block.data.type.SeaPickle;
import org.bukkit.block.data.type.Switch;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISRoomRunnable
implements Runnable {
    private final TARDIS plugin;
    private final Location l;
    private final JsonObject obj;
    private final int tardis_id;
    private final int progressLevel;
    private final int progressRow;
    private final int progressColumn;
    private final Material wall_type;
    private final Material floor_type;
    private final String room;
    private final Player player;
    private final UUID uuid;
    private final List<Chunk> chunkList = new ArrayList<Chunk>();
    private final List<Block> caneblocks = new ArrayList<Block>();
    private final List<Block> carrotblocks = new ArrayList<Block>();
    private final List<Block> farmlandblocks = new ArrayList<Block>();
    private final List<Block> iceblocks = new ArrayList<Block>();
    private final List<Block> lavablocks = new ArrayList<Block>();
    private final List<Block> lampblocks = new ArrayList<Block>();
    private final List<Block> melonblocks = new ArrayList<Block>();
    private final List<Block> potatoblocks = new ArrayList<Block>();
    private final List<Block> pumpkinblocks = new ArrayList<Block>();
    private final List<Block> wheatblocks = new ArrayList<Block>();
    private final List<Material> notThese = new ArrayList<Material>();
    private final List<BlockData> flora = new ArrayList<BlockData>();
    private final HashMap<Block, BlockData> cocoablocks = new HashMap();
    private final HashMap<Block, BlockData> doorblocks = new HashMap();
    private final HashMap<Block, BlockData> dripleafblocks = new HashMap();
    private final HashMap<Block, BlockData> leverblocks = new HashMap();
    private final HashMap<Block, BlockData> propagules = new HashMap();
    private final HashMap<Block, BlockData> redstoneTorchblocks = new HashMap();
    private final HashMap<Block, BlockData> seagrass = new HashMap();
    private final HashMap<Block, BlockData> signblocks = new HashMap();
    private final HashMap<Block, BlockData> torchblocks = new HashMap();
    private final HashMap<Block, BlockData> trapdoorblocks = new HashMap();
    private final HashMap<Block, BlockFace> mushroomblocks = new HashMap();
    private final HashMap<Block, BlockData> eyeBlocks = new HashMap();
    private final HashMap<Block, JsonObject> postSignBlocks = new HashMap();
    private final HashMap<Block, JsonObject> pots = new HashMap();
    private final HashMap<Block, TARDISBannerData> bannerblocks = new HashMap();
    private final BlockFace[] repeaterData = new BlockFace[6];
    private final HashMap<Integer, Integer> repeaterOrder = new HashMap();
    private final boolean wasResumed;
    private final List<String> postBlocks;
    private Location library;
    private int maze_count = 0;
    private int task;
    private int level;
    private int row;
    private int col;
    private int h;
    private int w;
    private int c;
    private int startx;
    private int starty;
    private int startz;
    private int resetx;
    private int resety;
    private int resetz;
    private boolean running;
    private World world;
    private JsonArray arr;
    private Location aqua_spawn;

    public TARDISRoomRunnable(TARDIS plugin, TARDISRoomData roomData, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.player = plugin.getServer().getPlayer(uuid);
        this.l = roomData.getLocation();
        this.obj = roomData.getSchematic();
        this.wall_type = roomData.getMiddleType();
        this.floor_type = roomData.getFloorType();
        this.room = roomData.getRoom();
        this.tardis_id = roomData.getTardis_id();
        this.progressLevel = roomData.getLevel();
        this.progressRow = roomData.getRow();
        this.progressColumn = roomData.getColumn();
        this.postBlocks = roomData.getPostBlocks();
        this.wasResumed = roomData.getLevel() > 0 || roomData.getRow() > 0 || roomData.getColumn() > 0;
        this.running = false;
        this.repeaterData[0] = BlockFace.NORTH;
        this.repeaterData[1] = BlockFace.NORTH;
        this.repeaterData[2] = BlockFace.EAST;
        this.repeaterData[3] = BlockFace.SOUTH;
        this.repeaterData[4] = BlockFace.NORTH;
        this.repeaterData[5] = BlockFace.EAST;
        this.repeaterOrder.put(2, 3);
        this.repeaterOrder.put(3, 2);
        this.repeaterOrder.put(4, 5);
        this.repeaterOrder.put(5, 4);
        this.notThese.add(Material.BIG_DRIPLEAF);
        this.notThese.add(Material.BIG_DRIPLEAF_STEM);
        this.notThese.add(Material.CARROTS);
        this.notThese.add(Material.COCOA);
        this.notThese.add(Material.IRON_TRAPDOOR);
        this.notThese.add(Material.LEVER);
        this.notThese.add(Material.MANGROVE_PROPAGULE);
        this.notThese.add(Material.MELON_STEM);
        this.notThese.add(Material.OAK_DOOR);
        this.notThese.add(Material.PISTON_HEAD);
        this.notThese.add(Material.POTATOES);
        this.notThese.add(Material.PUMPKIN_STEM);
        this.notThese.add(Material.REDSTONE_TORCH);
        this.notThese.add(Material.SEAGRASS);
        this.notThese.add(Material.SUGAR_CANE);
        this.notThese.add(Material.TORCH);
        this.notThese.add(Material.WHEAT);
        this.flora.add(Material.BRAIN_CORAL.createBlockData());
        this.flora.add(Material.BUBBLE_CORAL.createBlockData());
        this.flora.add(Material.FIRE_CORAL.createBlockData());
        this.flora.add(Material.HORN_CORAL.createBlockData());
        this.flora.add(Material.KELP_PLANT.createBlockData());
        this.flora.add(Material.SEA_PICKLE.createBlockData());
        this.flora.add(Material.SEAGRASS.createBlockData());
        this.flora.add(Material.TALL_SEAGRASS.createBlockData());
        this.flora.add(Material.TUBE_CORAL.createBlockData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        block238: {
            try {
                Material lgw;
                Material ow;
                UseClay use_clay;
                if (!this.running) {
                    String string;
                    this.level = this.progressLevel;
                    this.row = this.progressRow;
                    this.col = this.progressColumn;
                    JsonObject dim = this.obj.get("dimensions").getAsJsonObject();
                    this.arr = this.obj.get("input").getAsJsonArray();
                    this.h = dim.get("height").getAsInt() - 1;
                    this.w = dim.get("width").getAsInt() - 1;
                    this.c = dim.get("length").getAsInt();
                    this.startx = this.l.getBlockX() + this.progressRow;
                    this.starty = this.l.getBlockY() + this.progressLevel;
                    this.startz = this.l.getBlockZ() + this.progressColumn;
                    this.resetx = this.l.getBlockX();
                    this.resety = this.l.getBlockY();
                    this.resetz = this.l.getBlockZ();
                    this.world = this.l.getWorld();
                    if (this.wasResumed) {
                        block85: for (String s : this.postBlocks) {
                            String[] split = s.split("~");
                            Location location = TARDISStaticLocationGetters.getLocationFromDB(split[0]);
                            if (location == null) continue;
                            Block postBlock = this.world.getBlockAt(location);
                            BlockData postData = this.plugin.getServer().createBlockData(split[1]);
                            switch (postData.getMaterial()) {
                                case ICE: {
                                    this.iceblocks.add(postBlock);
                                    continue block85;
                                }
                                case LAVA: {
                                    this.lavablocks.add(postBlock);
                                    continue block85;
                                }
                                case BIG_DRIPLEAF: 
                                case BIG_DRIPLEAF_STEM: {
                                    this.dripleafblocks.put(postBlock, postData);
                                    continue block85;
                                }
                                case REDSTONE_LAMP: {
                                    this.lampblocks.add(postBlock);
                                    continue block85;
                                }
                                case TORCH: {
                                    this.torchblocks.put(postBlock, postData);
                                    continue block85;
                                }
                                case REDSTONE_TORCH: {
                                    this.redstoneTorchblocks.put(postBlock, postData);
                                    continue block85;
                                }
                                case COCOA: {
                                    this.cocoablocks.put(postBlock, postData);
                                    continue block85;
                                }
                                case SUGAR_CANE: {
                                    this.caneblocks.add(postBlock);
                                    continue block85;
                                }
                                case MANGROVE_PROPAGULE: {
                                    this.propagules.put(postBlock, postData);
                                    continue block85;
                                }
                                case SEAGRASS: {
                                    this.seagrass.put(postBlock, postData);
                                    continue block85;
                                }
                                case MELON_STEM: {
                                    this.melonblocks.add(postBlock);
                                    continue block85;
                                }
                                case POTATOES: {
                                    this.potatoblocks.add(postBlock);
                                    continue block85;
                                }
                                case CARROTS: {
                                    this.carrotblocks.add(postBlock);
                                    continue block85;
                                }
                                case PUMPKIN_STEM: {
                                    this.pumpkinblocks.add(postBlock);
                                    continue block85;
                                }
                                case WHEAT: {
                                    this.wheatblocks.add(postBlock);
                                    continue block85;
                                }
                                case FARMLAND: {
                                    this.farmlandblocks.add(postBlock);
                                    continue block85;
                                }
                                case OAK_DOOR: {
                                    this.doorblocks.put(postBlock, postData);
                                    continue block85;
                                }
                                case LEVER: {
                                    this.leverblocks.put(postBlock, postData);
                                    continue block85;
                                }
                                case IRON_TRAPDOOR: {
                                    this.trapdoorblocks.put(postBlock, postData);
                                    continue block85;
                                }
                            }
                            if (!Tag.ALL_SIGNS.isTagged((Keyed)postData.getMaterial())) continue;
                            this.signblocks.put(postBlock, postData);
                        }
                    } else {
                        TARDISRoomData tARDISRoomData = this.plugin.getTrackerKeeper().getRoomTasks().get(this.task);
                        tARDISRoomData.setPostBlocks(new ArrayList<String>());
                        this.plugin.getTrackerKeeper().getRoomTasks().put(this.task, tARDISRoomData);
                    }
                    this.plugin.getBuildKeeper().getRoomProgress().put(this.uuid, 0);
                    this.running = true;
                    String string2 = string = TARDISConstants.VOWELS.contains(this.room.substring(0, 1)) ? "an " + this.room : "a " + this.room;
                    if (this.room.equals("GRAVITY") || this.room.equals("ANTIGRAVITY")) {
                        String string3 = string + " WELL";
                    }
                    if (this.player != null) {
                        void var2_11;
                        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ROOM_START", var2_11);
                    }
                    if (this.room.equals("EYE")) {
                        new BiomeHelper().setCustomBiome("eye_of_harmony", this.l.getChunk(), this.starty);
                    }
                }
                if (this.level == this.h && this.row == this.w && this.col == this.c - 1) {
                    String string;
                    if (!this.iceblocks.isEmpty()) {
                        if (this.player != null) {
                            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ICE");
                        }
                        this.iceblocks.forEach(ice -> ice.setBlockData(TARDISConstants.WATER));
                        this.iceblocks.clear();
                    }
                    if (!this.lavablocks.isEmpty()) {
                        if (this.player != null) {
                            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "LAVA");
                        }
                        this.lavablocks.forEach(ice -> ice.setBlockData(TARDISConstants.LAVA));
                        this.lavablocks.clear();
                    }
                    if (!this.postSignBlocks.isEmpty()) {
                        TARDISSignSetter.setSigns(this.postSignBlocks, this.plugin, 0);
                    }
                    if (!this.pots.isEmpty()) {
                        for (Map.Entry entry : this.pots.entrySet()) {
                            TARDISPotSetter.decorate(this.plugin, (JsonObject)entry.getValue(), (Block)entry.getKey());
                        }
                    }
                    if (!this.propagules.isEmpty()) {
                        for (Map.Entry entry : this.propagules.entrySet()) {
                            ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                        }
                    }
                    if (!this.dripleafblocks.isEmpty()) {
                        for (Map.Entry entry : this.dripleafblocks.entrySet()) {
                            ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                        }
                    }
                    if (!this.signblocks.isEmpty()) {
                        for (Map.Entry entry : this.signblocks.entrySet()) {
                            ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                        }
                    }
                    if (!this.trapdoorblocks.isEmpty()) {
                        for (Map.Entry entry : this.trapdoorblocks.entrySet()) {
                            ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                        }
                    }
                    if (!this.seagrass.isEmpty()) {
                        for (Map.Entry entry : this.seagrass.entrySet()) {
                            ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                        }
                    }
                    if (this.room.equals("AQUARIUM")) {
                        BlockData f;
                        ResultSetFarming rsf;
                        if (this.aqua_spawn == null && (rsf = new ResultSetFarming(this.plugin, this.tardis_id)).resultSet()) {
                            this.aqua_spawn = TARDISStaticLocationGetters.getSpawnLocationFromDB(rsf.getFarming().aquarium());
                        }
                        int plusx = this.aqua_spawn.getBlockX() + 2;
                        int n = this.aqua_spawn.getBlockX() - 2;
                        int plusz = this.aqua_spawn.getBlockZ() + 2;
                        int minusz = this.aqua_spawn.getBlockZ() - 2;
                        int y = this.aqua_spawn.getBlockY();
                        int minusy = this.aqua_spawn.getBlockY() - 1;
                        for (int ax = plusx; ax < plusx + 5; ++ax) {
                            block93: for (int az = plusz; az < plusz + 5; ++az) {
                                if (!this.world.getBlockAt(ax, minusy, az).getType().equals((Object)Material.SAND) || TARDISConstants.RANDOM.nextInt(100) >= 66) continue;
                                f = this.flora.get(TARDISConstants.RANDOM.nextInt(this.flora.size()));
                                switch (f.getMaterial()) {
                                    case KELP: {
                                        this.world.getBlockAt(ax, y + 1, az).setBlockData(f);
                                        this.world.getBlockAt(ax, y + 2, az).setBlockData(f);
                                        continue block93;
                                    }
                                    case TALL_SEAGRASS: {
                                        ((Bisected)f).setHalf(Bisected.Half.BOTTOM);
                                        this.world.getBlockAt(ax, y, az).setBlockData(f);
                                        ((Bisected)f).setHalf(Bisected.Half.TOP);
                                        this.world.getBlockAt(ax, y + 1, az).setBlockData(f);
                                        continue block93;
                                    }
                                    case SEA_PICKLE: {
                                        ((SeaPickle)f).setPickles(TARDISConstants.RANDOM.nextInt(4) + 1);
                                        this.world.getBlockAt(ax, y, az).setBlockData(f);
                                        continue block93;
                                    }
                                    default: {
                                        this.world.getBlockAt(ax, y, az).setBlockData(f);
                                    }
                                }
                            }
                        }
                        for (int bx = n; bx > n - 5; --bx) {
                            block95: for (int bz = plusz; bz < plusz + 5; ++bz) {
                                if (!this.world.getBlockAt(bx, minusy, bz).getType().equals((Object)Material.SAND) || TARDISConstants.RANDOM.nextInt(100) >= 66) continue;
                                f = this.flora.get(TARDISConstants.RANDOM.nextInt(this.flora.size()));
                                switch (f.getMaterial()) {
                                    case KELP: {
                                        this.world.getBlockAt(bx, y + 1, bz).setBlockData(f);
                                        this.world.getBlockAt(bx, y + 2, bz).setBlockData(f);
                                        continue block95;
                                    }
                                    case TALL_SEAGRASS: {
                                        ((Bisected)f).setHalf(Bisected.Half.BOTTOM);
                                        this.world.getBlockAt(bx, y, bz).setBlockData(f);
                                        ((Bisected)f).setHalf(Bisected.Half.TOP);
                                        this.world.getBlockAt(bx, y + 1, bz).setBlockData(f);
                                        continue block95;
                                    }
                                    case SEA_PICKLE: {
                                        ((SeaPickle)f).setPickles(TARDISConstants.RANDOM.nextInt(4) + 1);
                                        this.world.getBlockAt(bx, y, bz).setBlockData(f);
                                        continue block95;
                                    }
                                    default: {
                                        this.world.getBlockAt(bx, y, bz).setBlockData(f);
                                    }
                                }
                            }
                        }
                        for (int cx = n; cx > n - 5; --cx) {
                            block97: for (int cz = minusz; cz > minusz - 5; --cz) {
                                if (!this.world.getBlockAt(cx, minusy, cz).getType().equals((Object)Material.SAND) || TARDISConstants.RANDOM.nextInt(100) >= 66) continue;
                                f = this.flora.get(TARDISConstants.RANDOM.nextInt(this.flora.size()));
                                switch (f.getMaterial()) {
                                    case KELP: {
                                        this.world.getBlockAt(cx, y + 1, cz).setBlockData(f);
                                        this.world.getBlockAt(cx, y + 2, cz).setBlockData(f);
                                        continue block97;
                                    }
                                    case TALL_SEAGRASS: {
                                        ((Bisected)f).setHalf(Bisected.Half.BOTTOM);
                                        this.world.getBlockAt(cx, y, cz).setBlockData(f);
                                        ((Bisected)f).setHalf(Bisected.Half.TOP);
                                        this.world.getBlockAt(cx, y + 1, cz).setBlockData(f);
                                        continue block97;
                                    }
                                    case SEA_PICKLE: {
                                        ((SeaPickle)f).setPickles(TARDISConstants.RANDOM.nextInt(4) + 1);
                                        this.world.getBlockAt(cx, y, cz).setBlockData(f);
                                        continue block97;
                                    }
                                    default: {
                                        this.world.getBlockAt(cx, y, cz).setBlockData(f);
                                    }
                                }
                            }
                        }
                        for (int dx = plusx; dx < plusx + 5; ++dx) {
                            block99: for (int dz = minusz; dz > minusz - 5; --dz) {
                                if (!this.world.getBlockAt(dx, minusy, dz).getType().equals((Object)Material.SAND) || TARDISConstants.RANDOM.nextInt(100) >= 66) continue;
                                f = this.flora.get(TARDISConstants.RANDOM.nextInt(this.flora.size()));
                                switch (f.getMaterial()) {
                                    case KELP: {
                                        this.world.getBlockAt(dx, y + 1, dz).setBlockData(f);
                                        this.world.getBlockAt(dx, y + 2, dz).setBlockData(f);
                                        continue block99;
                                    }
                                    case TALL_SEAGRASS: {
                                        ((Bisected)f).setHalf(Bisected.Half.BOTTOM);
                                        this.world.getBlockAt(dx, y, dz).setBlockData(f);
                                        ((Bisected)f).setHalf(Bisected.Half.TOP);
                                        this.world.getBlockAt(dx, y + 1, dz).setBlockData(f);
                                        continue block99;
                                    }
                                    case SEA_PICKLE: {
                                        ((SeaPickle)f).setPickles(TARDISConstants.RANDOM.nextInt(4) + 1);
                                        this.world.getBlockAt(dx, y, dz).setBlockData(f);
                                        continue block99;
                                    }
                                    default: {
                                        this.world.getBlockAt(dx, y, dz).setBlockData(f);
                                    }
                                }
                            }
                        }
                    }
                    if (this.obj.has("paintings")) {
                        void var2_26;
                        JsonArray paintings = (JsonArray)this.obj.get("paintings");
                        boolean bl = false;
                        while (var2_26 < paintings.size()) {
                            Location pl;
                            JsonObject painting = paintings.get((int)var2_26).getAsJsonObject();
                            JsonObject rel = painting.get("rel_location").getAsJsonObject();
                            int px = rel.get("x").getAsInt();
                            int py = rel.get("y").getAsInt();
                            int pz = rel.get("z").getAsInt();
                            BlockFace facing = BlockFace.valueOf((String)painting.get("facing").getAsString());
                            String which = painting.get("art").getAsString();
                            Art art = null;
                            if (which.contains(":")) {
                                pl = TARDISPainting.calculatePosition(which.split(":")[1], facing, new Location(this.world, (double)(this.resetx + px), (double)(this.resety + py), (double)(this.resetz + pz)));
                            } else {
                                art = (Art)RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT).get(new NamespacedKey("minecraft", which.toLowerCase(Locale.ROOT)));
                                pl = TARDISPainting.calculatePosition(art, facing, new Location(this.world, (double)(this.resetx + px), (double)(this.resety + py), (double)(this.resetz + pz)));
                            }
                            try {
                                Painting ent = (Painting)this.world.spawnEntity(pl, EntityType.PAINTING);
                                ent.teleport(pl);
                                ent.setFacingDirection(facing, true);
                                if (art != null) {
                                    ent.setArt(art, true);
                                } else {
                                    DataPackPainting.setCustomVariant(ent, which);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                this.plugin.debug("Invalid painting location!" + String.valueOf(pl));
                            }
                            ++var2_26;
                        }
                    }
                    Location start = new Location(this.world, (double)this.resetx, (double)this.resety, (double)this.resetz);
                    if (this.obj.has("item_frames")) {
                        JsonArray jsonArray = this.obj.get("item_frames").getAsJsonArray();
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            TARDISItemFrameSetter.curate(jsonArray.get(i).getAsJsonObject(), start, this.tardis_id);
                        }
                    }
                    if (this.obj.has("item_displays")) {
                        JsonArray jsonArray = this.obj.get("item_displays").getAsJsonArray();
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            TARDISItemDisplaySetter.fakeBlock(jsonArray.get(i).getAsJsonObject(), start, this.tardis_id);
                        }
                    }
                    if (this.room.equals("EYE")) {
                        this.eyeBlocks.forEach((key, value) -> key.setBlockData(value, true));
                        this.eyeBlocks.clear();
                    }
                    if (this.room.equals("BAKER") || this.room.equals("WOOD")) {
                        this.mushroomblocks.forEach((key, value) -> {
                            BlockData repeater = Material.REPEATER.createBlockData();
                            Directional directional = (Directional)repeater;
                            directional.setFacing(value);
                            key.setBlockData((BlockData)directional, true);
                        });
                        this.mushroomblocks.clear();
                    }
                    if (this.room.equals("ARBORETUM") || this.room.equals("GREENHOUSE")) {
                        this.caneblocks.forEach(cane -> cane.setBlockData(Material.SUGAR_CANE.createBlockData()));
                        this.caneblocks.clear();
                        this.cocoablocks.forEach((key, value) -> key.setBlockData(value, true));
                        this.cocoablocks.clear();
                        this.melonblocks.forEach(melon -> melon.setBlockData(Material.MELON_STEM.createBlockData()));
                        this.melonblocks.clear();
                        this.pumpkinblocks.forEach(pumpkin -> pumpkin.setBlockData(Material.PUMPKIN_STEM.createBlockData()));
                        this.pumpkinblocks.clear();
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            this.wheatblocks.forEach(wheat -> wheat.setBlockData(Material.WHEAT.createBlockData()));
                            this.wheatblocks.clear();
                            this.carrotblocks.forEach(carrot -> carrot.setBlockData(Material.CARROTS.createBlockData()));
                            this.carrotblocks.clear();
                            this.potatoblocks.forEach(potato -> potato.setBlockData(Material.POTATOES.createBlockData()));
                            this.potatoblocks.clear();
                        }, 5L);
                    }
                    if (this.room.equals("VILLAGE") || this.room.equals("SHELL")) {
                        this.doorblocks.forEach((key, value) -> key.setBlockData(value, true));
                        this.doorblocks.clear();
                    }
                    if (this.room.equals("LIBRARY") && this.library != null) {
                        new LibraryCatalogue().label(this.library);
                    }
                    this.farmlandblocks.forEach(fl -> {
                        BlockData farmData = Material.FARMLAND.createBlockData();
                        Farmland farmland = (Farmland)farmData;
                        farmland.setMoisture(farmland.getMaximumMoisture());
                        fl.setBlockData((BlockData)farmland);
                    });
                    this.leverblocks.forEach((key, value) -> key.setBlockData(value, true));
                    this.leverblocks.clear();
                    if (this.player != null) {
                        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ROOM_POWER");
                    }
                    if (this.plugin.getConfig().getBoolean("allow.dynamic_lamps")) {
                        ResultSetPlayerPrefs resultSetPlayerPrefs = new ResultSetPlayerPrefs(this.plugin, this.uuid.toString());
                        if (resultSetPlayerPrefs.resultSet() && resultSetPlayerPrefs.isDynamicLightsOn()) {
                            TardisLight light = resultSetPlayerPrefs.getLights();
                            this.lampblocks.forEach(lamp -> TARDISDisplayItemUtils.set(light.getOn(), lamp, this.tardis_id));
                        } else {
                            this.lampblocks.forEach(lamp -> lamp.setBlockData(TARDISConstants.LAMP));
                        }
                    } else {
                        this.lampblocks.forEach(lamp -> lamp.setBlockData(TARDISConstants.LAMP));
                    }
                    this.lampblocks.clear();
                    this.torchblocks.forEach((key, value) -> key.setBlockData(value, true));
                    this.torchblocks.clear();
                    this.redstoneTorchblocks.forEach((key, value) -> key.setBlockData(value, true));
                    this.torchblocks.clear();
                    TARDISBannerSetter.setBanners(this.bannerblocks);
                    if (!this.chunkList.isEmpty()) {
                        this.chunkList.forEach(ch -> ch.removePluginChunkTicket((Plugin)this.plugin));
                    }
                    this.plugin.getTrackerKeeper().getRoomTasks().remove(this.task);
                    this.plugin.getServer().getScheduler().cancelTask(this.task);
                    this.task = 0;
                    String string4 = string = this.room.equals("GRAVITY") || this.room.equals("ANTIGRAVITY") ? this.room + " WELL" : this.room;
                    if (this.player != null) {
                        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ROOM_FINISHED", string);
                    }
                    this.plugin.getBuildKeeper().getRoomProgress().remove(this.uuid);
                    this.plugin.getTrackerKeeper().getIsGrowingRooms().remove(this.tardis_id);
                    break block238;
                }
                TARDISRoomData rd = this.plugin.getTrackerKeeper().getRoomTasks().get(this.task);
                JsonObject jsonObject = this.arr.get(this.level).getAsJsonArray().get(this.row).getAsJsonArray().get(this.col).getAsJsonObject();
                String jData = jsonObject.get("data").getAsString();
                if (jData.contains("minecraft:cauldron[level=")) {
                    jData = jData.replace("cauldron[level=0]", "cauldron").replace("cauldron[level=3]", "water_cauldron[level=3]");
                }
                BlockData data = this.plugin.getServer().createBlockData(jData);
                Material type = data.getMaterial();
                try {
                    use_clay = UseClay.valueOf(this.plugin.getConfig().getString("creation.use_clay"));
                }
                catch (IllegalArgumentException e) {
                    use_clay = UseClay.WOOL;
                }
                Material gw = switch (use_clay) {
                    case UseClay.TERRACOTTA -> {
                        ow = Material.ORANGE_TERRACOTTA;
                        lgw = Material.LIGHT_GRAY_TERRACOTTA;
                        yield Material.GRAY_TERRACOTTA;
                    }
                    case UseClay.CONCRETE -> {
                        ow = Material.ORANGE_CONCRETE;
                        lgw = Material.LIGHT_GRAY_CONCRETE;
                        yield Material.GRAY_CONCRETE;
                    }
                    default -> {
                        ow = Material.ORANGE_WOOL;
                        lgw = Material.LIGHT_GRAY_WOOL;
                        yield Material.GRAY_WOOL;
                    }
                };
                if (type.equals((Object)Material.GRAY_WOOL)) {
                    data = gw.createBlockData();
                }
                if (type.equals((Object)Material.ORANGE_WOOL)) {
                    data = this.wall_type.equals((Object)Material.ORANGE_WOOL) || (this.room.equals("GRAVITY") || this.room.equals("ANTIGRAVITY")) && (this.wall_type.equals((Object)Material.LIME_WOOL) || this.wall_type.equals((Object)Material.PINK_WOOL)) ? ow.createBlockData() : this.wall_type.createBlockData();
                }
                if (type.equals((Object)Material.LIGHT_GRAY_WOOL)) {
                    data = this.floor_type.equals((Object)Material.LIGHT_GRAY_WOOL) || (this.room.equals("GRAVITY") || this.room.equals("ANTIGRAVITY")) && (this.floor_type.equals((Object)Material.LIME_WOOL) || this.floor_type.equals((Object)Material.PINK_WOOL)) ? lgw.createBlockData() : this.floor_type.createBlockData();
                }
                if (Tag.ALL_SIGNS.isTagged((Keyed)type)) {
                    Block sign = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.postSignBlocks.put(sign, jsonObject);
                    this.signblocks.put(sign, data);
                }
                if (type.equals((Object)Material.DECORATED_POT) && jsonObject.has("pot")) {
                    Block pot = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.pots.put(pot, jsonObject.get("pot").getAsJsonObject());
                }
                if (type.equals((Object)Material.BEEHIVE) && this.room.equals("APIARY")) {
                    HashMap<String, Object> seta = new HashMap<String, Object>();
                    seta.put("apiary", this.world.getName() + ":" + this.startx + ":" + (this.starty + 1) + ":" + this.startz);
                    ResultSetFarming rsa = new ResultSetFarming(this.plugin, this.tardis_id);
                    if (rsa.resultSet()) {
                        HashMap<String, Object> wherea = new HashMap<String, Object>();
                        wherea.put("tardis_id", this.tardis_id);
                        this.plugin.getQueryFactory().doUpdate("farming", seta, wherea);
                    } else {
                        seta.put("tardis_id", this.tardis_id);
                        this.plugin.getQueryFactory().doInsert("farming", seta);
                    }
                }
                if (type.equals((Object)Material.CHEST) && this.room.equals("HARMONY")) {
                    this.plugin.getQueryFactory().insertControl(this.tardis_id, 34, new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz).toString(), 1);
                }
                if (type.equals((Object)Material.CHEST) && this.room.equals("LIBRARY")) {
                    Location pos = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz);
                    HashMap<String, Object> setl = new HashMap<String, Object>();
                    setl.put("tardis_id", this.tardis_id);
                    setl.put("location", pos.toString());
                    setl.put("chest_type", "LIBRARY");
                    this.plugin.getQueryFactory().doInsert("vaults", setl);
                    this.library = pos.clone().add(-8.0, -4.0, -8.0);
                }
                if (type.equals((Object)Material.RED_SANDSTONE_WALL) && this.room.equals("EYE")) {
                    Block wall = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.eyeBlocks.put(wall, data);
                }
                if (type.equals((Object)Material.SHROOMLIGHT) && this.room.equals("EYE")) {
                    double sx = (double)this.startx + 0.5;
                    double sy = (double)this.starty + 0.5;
                    double sz = (double)this.startz + 0.5;
                    Location item = new Location(this.world, sx, sy, sz);
                    ItemDisplay display = (ItemDisplay)this.world.spawnEntity(item, EntityType.ITEM_DISPLAY);
                    ItemStack is = ItemStack.of((Material)Material.MAGMA_BLOCK);
                    ItemMeta im = is.getItemMeta();
                    im.displayName((Component)Component.text((String)"Sphere Normal"));
                    is.setItemMeta(im);
                    display.setItemStack(is);
                    display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.GROUND);
                    this.plugin.getQueryFactory().insertSyncControl(this.tardis_id, 53, item.toString(), 0);
                    data = TARDISConstants.BARRIER;
                    if (this.plugin.getConfig().getBoolean("eye_of_harmony.particles")) {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            int task = new EyeOfHarmonyParticles(this.plugin).start(this.tardis_id, 1, this.uuid);
                            if (task != -1) {
                                HashMap<String, Object> set = new HashMap<String, Object>();
                                set.put("task", task);
                                HashMap<String, Object> where = new HashMap<String, Object>();
                                where.put("tardis_id", this.tardis_id);
                                this.plugin.getQueryFactory().doSyncUpdate("eyes", set, where);
                            }
                        }, 600L);
                    }
                }
                if (type.equals((Object)Material.BARRIER) && this.room.equals("EYE")) {
                    String dbStr = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz).toString();
                    this.plugin.getQueryFactory().insertControl(this.tardis_id, 54, dbStr, 0);
                }
                if (type.equals((Object)Material.TRAPPED_CHEST) && this.room.equals("VAULT") && this.player != null && TARDISPermission.hasPermission(this.player, "tardis.vault")) {
                    int mz;
                    int mx = this.startx % 16;
                    if (mx < 0) {
                        mx += 16;
                    }
                    if ((mz = this.startz % 16) < 0) {
                        mz += 16;
                    }
                    int x = this.startx - mx;
                    int y = this.starty - this.starty % 16;
                    int z = this.startz - mz;
                    String pos = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz).toString();
                    HashMap<String, Object> setv = new HashMap<String, Object>();
                    setv.put("tardis_id", this.tardis_id);
                    setv.put("location", pos);
                    setv.put("x", x);
                    setv.put("y", y);
                    setv.put("z", z);
                    this.plugin.getQueryFactory().doInsert("vaults", setv);
                }
                if (type.equals((Object)Material.SPAWNER) && this.room.equals("FARM")) {
                    HashMap<String, Object> setf = new HashMap<String, Object>();
                    setf.put("farm", this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz);
                    ResultSetFarming rsf = new ResultSetFarming(this.plugin, this.tardis_id);
                    if (rsf.resultSet()) {
                        HashMap<String, Object> wheref = new HashMap<String, Object>();
                        wheref.put("tardis_id", this.tardis_id);
                        this.plugin.getQueryFactory().doUpdate("farming", setf, wheref);
                    } else {
                        setf.put("tardis_id", this.tardis_id);
                        this.plugin.getQueryFactory().doInsert("farming", setf);
                    }
                    BlockData blockData = data = this.floor_type.equals((Object)Material.LIGHT_GRAY_WOOL) ? lgw.createBlockData() : this.floor_type.createBlockData();
                    if (this.player != null) {
                        this.turnOnFarming(this.player);
                    }
                }
                if (type.equals((Object)Material.OAK_PRESSURE_PLATE) && this.room.equals("LAZARUS")) {
                    String plate = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz).toString();
                    this.plugin.getQueryFactory().insertControl(this.tardis_id, 19, plate, 0);
                }
                if (type.equals((Object)Material.SOUL_SAND) && (this.room.equals("STABLE") || this.room.equals("VILLAGE") || this.room.equals("RENDERER") || this.room.equals("LAVA") || this.room.equals("ALLAY") || this.room.equals("ZERO") || this.room.equals("GEODE") || this.room.equals("HUTCH") || this.room.equals("IGLOO") || this.room.equals("IISTUBIL") || this.room.equals("MANGROVE") || this.room.equals("PEN") || this.room.equals("STALL") || this.room.equals("BAMBOO") || this.room.equals("BIRDCAGE") || this.room.equals("MAZE") || this.room.equals("GARDEN") || this.room.equals("HAPPY"))) {
                    HashMap<String, Object> sets = new HashMap<String, Object>();
                    sets.put(this.room.toLowerCase(Locale.ROOT), this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz);
                    HashMap<String, Object> wheres = new HashMap<String, Object>();
                    wheres.put("tardis_id", this.tardis_id);
                    switch (this.room) {
                        case "GARDEN": {
                            break;
                        }
                        case "RENDERER": 
                        case "ZERO": {
                            this.plugin.getQueryFactory().doUpdate("tardis", sets, wheres);
                            break;
                        }
                        case "MAZE": {
                            String loc_str = TARDISStaticLocationGetters.makeLocationStr(this.world, this.startx, this.starty + 1, this.startz);
                            this.plugin.getQueryFactory().insertControl(this.tardis_id, 44, loc_str, 0);
                            break;
                        }
                        default: {
                            ResultSetFarming rsf = new ResultSetFarming(this.plugin, this.tardis_id);
                            if (rsf.resultSet()) {
                                this.plugin.getQueryFactory().doUpdate("farming", sets, wheres);
                                break;
                            }
                            sets.put("tardis_id", this.tardis_id);
                            this.plugin.getQueryFactory().doInsert("farming", sets);
                        }
                    }
                    switch (Room.valueOf(this.room)) {
                        case ALLAY: {
                            data = Material.LIGHT_GRAY_WOOL.createBlockData();
                            break;
                        }
                        case VILLAGE: {
                            data = Material.COBBLESTONE.createBlockData();
                            break;
                        }
                        case HUTCH: 
                        case STABLE: 
                        case STALL: 
                        case MAZE: {
                            data = Material.GRASS_BLOCK.createBlockData();
                            break;
                        }
                        case BAMBOO: 
                        case BIRDCAGE: {
                            data = Material.PODZOL.createBlockData();
                            break;
                        }
                        case GEODE: {
                            data = Material.CLAY.createBlockData();
                            break;
                        }
                        case HAPPY: {
                            data = Material.BLUE_ICE.createBlockData();
                            break;
                        }
                        case IGLOO: {
                            data = Material.PACKED_ICE.createBlockData();
                            break;
                        }
                        case IISTUBIL: {
                            data = Material.TERRACOTTA.createBlockData();
                            break;
                        }
                        case LAVA: {
                            data = Material.NETHERRACK.createBlockData();
                            break;
                        }
                        case MANGROVE: {
                            data = TARDISConstants.WATER;
                            break;
                        }
                        case PEN: {
                            data = Material.MOSS_BLOCK.createBlockData();
                            break;
                        }
                        case ZERO: {
                            data = Material.PINK_CARPET.createBlockData();
                            break;
                        }
                        case GARDEN: {
                            data = Material.GRASS_BLOCK.createBlockData();
                            HashMap<String, Object> setG = new HashMap<String, Object>();
                            setG.put("tardis_id", this.tardis_id);
                            setG.put("world", this.world.getName());
                            setG.put("minx", this.startx - 6);
                            setG.put("maxx", this.startx + 6);
                            setG.put("y", this.starty);
                            setG.put("minz", this.startz - 6);
                            setG.put("maxz", this.startz + 6);
                            this.plugin.getQueryFactory().doInsert("gardens", setG);
                            break;
                        }
                        default: {
                            data = TARDISConstants.BLACK;
                            if (!this.plugin.isWorldGuardOnServer() || !this.plugin.getConfig().getBoolean("preferences.use_worldguard")) break;
                            String name = "";
                            if (this.player == null) {
                                ResultSetTardisTimeLordName rsn = new ResultSetTardisTimeLordName(this.plugin);
                                if (rsn.fromID(this.tardis_id)) {
                                    name = rsn.getOwner();
                                }
                            } else {
                                name = this.player.getName();
                            }
                            if (name.isEmpty()) break;
                            Location one = new Location(this.world, (double)(this.startx - 6), (double)this.starty, (double)(this.startz - 6));
                            Location two = new Location(this.world, (double)(this.startx + 6), (double)(this.starty + 8), (double)(this.startz + 6));
                            this.plugin.getWorldGuardUtils().addRendererProtection(name, one, two);
                        }
                    }
                    if (!(this.room.equals("ZERO") || this.room.equals("RENDERER") || this.room.equals("MAZE") || this.room.equals("GARDEN") || this.player == null)) {
                        this.turnOnFarming(this.player);
                    }
                }
                if (type.equals((Object)Material.CRIMSON_HYPHAE) && this.room.equals("HAPPY")) {
                    String loc_str = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz).toString();
                    this.plugin.getQueryFactory().insertControl(this.tardis_id, 58, loc_str, 0);
                    ResultSetHappy rsh = new ResultSetHappy(this.plugin);
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    if (rsh.fromId(this.tardis_id)) {
                        set.put("slots", "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
                        HashMap<String, Object> where = new HashMap<String, Object>();
                        where.put("tardis_id", this.tardis_id);
                        this.plugin.getQueryFactory().doUpdate("happy", set, where);
                    } else {
                        set.put("tardis_id", this.tardis_id);
                        this.plugin.getQueryFactory().doInsert("happy", set);
                    }
                    Block lever = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    Switch happyLever = (Switch)Material.LEVER.createBlockData();
                    happyLever.setAttachedFace(FaceAttachable.AttachedFace.WALL);
                    happyLever.setFacing(BlockFace.WEST);
                    happyLever.setPowered(true);
                    this.leverblocks.put(lever, (BlockData)happyLever);
                }
                if ((type.equals((Object)Material.SOUL_SAND) || type.equals((Object)Material.CARVED_PUMPKIN)) && this.room.equals("SMELTER")) {
                    String pos = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz).toString();
                    HashMap<String, Object> setsm = new HashMap<String, Object>();
                    setsm.put("tardis_id", this.tardis_id);
                    setsm.put("location", pos);
                    setsm.put("chest_type", type.equals((Object)Material.CARVED_PUMPKIN) ? "SMELT" : "FUEL");
                    this.plugin.getQueryFactory().doInsert("vaults", setsm);
                    data = Material.CHEST.createBlockData();
                }
                if (type.equals((Object)Material.DEAD_HORN_CORAL_BLOCK) && this.room.equals("AQUARIUM")) {
                    HashMap<String, Object> setaqua = new HashMap<String, Object>();
                    setaqua.put("aquarium", this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz);
                    ResultSetFarming rsf = new ResultSetFarming(this.plugin, this.tardis_id);
                    if (rsf.resultSet()) {
                        HashMap<String, Object> wheres = new HashMap<String, Object>();
                        wheres.put("tardis_id", this.tardis_id);
                        this.plugin.getQueryFactory().doUpdate("farming", setaqua, wheres);
                    } else {
                        setaqua.put("tardis_id", this.tardis_id);
                        this.plugin.getQueryFactory().doInsert("farming", setaqua);
                    }
                    BlockData blockData = data = this.floor_type.equals((Object)Material.LIGHT_GRAY_WOOL) ? lgw.createBlockData() : this.floor_type.createBlockData();
                    if (this.player != null) {
                        this.turnOnFarming(this.player);
                    }
                    this.aqua_spawn = new Location(this.world, (double)this.startx, (double)(this.starty + 1), (double)this.startz);
                }
                if (type.equals((Object)Material.STONE_BUTTON) && this.room.equals("SHELL")) {
                    String loc_str = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz).toString();
                    this.plugin.getQueryFactory().insertControl(this.tardis_id, 25, loc_str, 0);
                }
                if (type.equals((Object)Material.OAK_DOOR) && (this.room.equals("VILLAGE") || this.room.equals("SHELL"))) {
                    Block door = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.doorblocks.put(door, data);
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + data.getAsString());
                }
                if (type.equals((Object)Material.TORCH)) {
                    Block torch = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.torchblocks.put(torch, data);
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + data.getAsString());
                }
                if (type.equals((Object)Material.LEVER)) {
                    Block lever = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.leverblocks.put(lever, data);
                }
                if (type.equals((Object)Material.IRON_TRAPDOOR)) {
                    Block trap = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.trapdoorblocks.put(trap, data);
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + data.getAsString());
                }
                if (type.equals((Object)Material.REDSTONE_TORCH)) {
                    Block torch = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.redstoneTorchblocks.put(torch, data);
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + data.getAsString());
                }
                if (TARDISStaticUtils.isBanner(type)) {
                    JsonObject state;
                    Block banner = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    JsonObject jsonObject2 = state = jsonObject.has("banner") ? jsonObject.get("banner").getAsJsonObject() : null;
                    if (state != null) {
                        TARDISBannerData tbd = new TARDISBannerData(data, state);
                        this.bannerblocks.put(banner, tbd);
                    }
                }
                if (type.equals((Object)Material.FARMLAND)) {
                    Block farmland = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.farmlandblocks.add(farmland);
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + Material.FARMLAND.createBlockData().getAsString());
                }
                if (type.equals((Object)Material.LAVA)) {
                    Block lava = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.lavablocks.add(lava);
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + TARDISConstants.LAVA.getAsString());
                }
                if (this.room.equals("ARBORETUM") || this.room.equals("GREENHOUSE")) {
                    if (type.equals((Object)Material.SUGAR_CANE)) {
                        Block cane2 = this.world.getBlockAt(this.startx, this.starty, this.startz);
                        this.caneblocks.add(cane2);
                        rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + Material.SUGAR_CANE.createBlockData().getAsString());
                    }
                    if (type.equals((Object)Material.COCOA)) {
                        Block cocoa = this.world.getBlockAt(this.startx, this.starty, this.startz);
                        this.cocoablocks.put(cocoa, data);
                        rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + Material.COCOA.createBlockData().getAsString());
                    }
                    if (type.equals((Object)Material.WHEAT)) {
                        Block crops = this.world.getBlockAt(this.startx, this.starty, this.startz);
                        this.wheatblocks.add(crops);
                        rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + Material.WHEAT.createBlockData().getAsString());
                    }
                    if (type.equals((Object)Material.MELON_STEM)) {
                        Block melon2 = this.world.getBlockAt(this.startx, this.starty, this.startz);
                        this.melonblocks.add(melon2);
                        rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + Material.MELON_STEM.createBlockData().getAsString());
                    }
                    if (type.equals((Object)Material.PUMPKIN_STEM)) {
                        Block pumpkin2 = this.world.getBlockAt(this.startx, this.starty, this.startz);
                        this.pumpkinblocks.add(pumpkin2);
                        rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + Material.PUMPKIN_STEM.createBlockData().getAsString());
                    }
                    if (type.equals((Object)Material.CARROTS)) {
                        Block carrot = this.world.getBlockAt(this.startx, this.starty, this.startz);
                        this.carrotblocks.add(carrot);
                        rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + Material.CARROTS.createBlockData().getAsString());
                    }
                    if (type.equals((Object)Material.POTATOES)) {
                        Block potato = this.world.getBlockAt(this.startx, this.starty, this.startz);
                        this.potatoblocks.add(potato);
                        rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + Material.POTATOES.createBlockData().getAsString());
                    }
                    if (this.level == 4 && this.room.equals("GREENHOUSE")) {
                        this.iceblocks.forEach(ice -> ice.setBlockData(TARDISConstants.WATER));
                        this.iceblocks.clear();
                    }
                }
                if (type.equals((Object)Material.MANGROVE_PROPAGULE)) {
                    this.propagules.put(this.world.getBlockAt(this.startx, this.starty, this.startz), data);
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + data.getAsString());
                }
                if (type.equals((Object)Material.BIG_DRIPLEAF) || type.equals((Object)Material.BIG_DRIPLEAF_STEM)) {
                    this.dripleafblocks.put(this.world.getBlockAt(this.startx, this.starty, this.startz), data);
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + data.getAsString());
                }
                if (type.equals((Object)Material.SEAGRASS) || type.equals((Object)Material.TALL_SEAGRASS)) {
                    this.seagrass.put(this.world.getBlockAt(this.startx, this.starty, this.startz), data);
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + data.getAsString());
                }
                if (this.room.equals("RAIL") && type.equals((Object)Material.OAK_FENCE)) {
                    String loc = this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz;
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("rail", loc);
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("tardis_id", this.tardis_id);
                    this.plugin.getQueryFactory().doUpdate("tardis", set, where);
                }
                if (type.equals((Object)Material.BEDROCK) && !this.room.equals("SHELL") || type.equals((Object)Material.SOUL_SAND) && this.room.equals("SHELL")) {
                    if (this.checkRoomNextDoor(this.world.getBlockAt(this.startx, this.starty, this.startz))) {
                        data = TARDISConstants.AIR;
                    } else if (ow.equals((Object)Material.ORANGE_WOOL) && this.wall_type.equals((Object)Material.ORANGE_WOOL)) {
                        if (!TARDISFloodgate.isFloodgateEnabled() || this.player != null && !TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId())) {
                            data = TARDISConstants.BARRIER;
                            TARDISDisplayItemUtils.set(TARDISDisplayItem.HEXAGON, this.world, this.startx, this.starty, this.startz);
                        }
                    } else {
                        BlockData blockData = data = this.wall_type.equals((Object)Material.ORANGE_WOOL) ? ow.createBlockData() : this.wall_type.createBlockData();
                    }
                }
                if (type.equals((Object)Material.STICKY_PISTON) && this.starty == this.resety + 2) {
                    Block bottomdoorblock = null;
                    if (this.startx == this.resetx + 8 && this.startz == this.resetz) {
                        bottomdoorblock = this.world.getBlockAt(this.startx, this.starty + 2, this.startz - 1);
                    }
                    if (this.startx == this.resetx && this.startz == this.resetz + 8) {
                        bottomdoorblock = this.world.getBlockAt(this.startx - 1, this.starty + 2, this.startz);
                    }
                    if (bottomdoorblock != null) {
                        Block topdoorblock = bottomdoorblock.getRelative(BlockFace.UP);
                        bottomdoorblock.setBlockData(TARDISConstants.AIR);
                        topdoorblock.setBlockData(TARDISConstants.AIR);
                        TARDISDisplayItemUtils.remove(bottomdoorblock);
                        TARDISDisplayItemUtils.remove(topdoorblock);
                    }
                }
                if (type.equals((Object)Material.SPONGE)) {
                    data = TARDISConstants.AIR;
                } else {
                    Block existing = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    if (!(existing.getType().isAir() || this.room.equals("BAMBOO") && existing.getType().equals((Object)Material.BAMBOO))) {
                        if (this.room.equals("GRAVITY") || this.room.equals("ANTIGRAVITY")) {
                            switch (type) {
                                case AIR: 
                                case GRAY_WOOL: 
                                case LIGHT_GRAY_WOOL: 
                                case ORANGE_WOOL: 
                                case STONE_BRICKS: {
                                    break;
                                }
                                default: {
                                    data = existing.getBlockData();
                                    break;
                                }
                            }
                        } else {
                            data = existing.getBlockData();
                        }
                    }
                }
                Chunk thisChunk = this.world.getChunkAt(this.world.getBlockAt(this.startx, this.starty, this.startz));
                thisChunk.addPluginChunkTicket((Plugin)this.plugin);
                this.chunkList.add(thisChunk);
                if (!this.notThese.contains(type) && !type.equals((Object)Material.MUSHROOM_STEM)) {
                    if (type.equals((Object)Material.WATER)) {
                        TARDISBlockSetters.setBlock(this.world, this.startx, this.starty, this.startz, TARDISConstants.ICE);
                    } else if (type.equals((Object)Material.LAVA)) {
                        TARDISBlockSetters.setBlock(this.world, this.startx, this.starty, this.startz, Material.ORANGE_STAINED_GLASS);
                    } else {
                        TARDISBlockSetters.setBlock(this.world, this.startx, this.starty, this.startz, data);
                    }
                }
                if ((type.equals((Object)Material.WATER) || type.equals((Object)Material.ICE)) && !this.room.equals("IGLOO")) {
                    Block icy = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.iceblocks.add(icy);
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + TARDISConstants.ICE.getAsString());
                }
                if (type.equals((Object)Material.REDSTONE_LAMP)) {
                    Block lamp2 = this.world.getBlockAt(this.startx, this.starty, this.startz);
                    this.lampblocks.add(lamp2);
                    if (rd == null) {
                        this.plugin.debug("Room Data NULL");
                        this.plugin.getServer().getScheduler().cancelTask(this.task);
                        this.task = 0;
                        return;
                    }
                    if (rd.getPostBlocks() == null) {
                        this.plugin.debug("Post Blocks NULL");
                        this.plugin.getServer().getScheduler().cancelTask(this.task);
                        this.task = 0;
                        return;
                    }
                    rd.getPostBlocks().add(this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz + "~" + TARDISConstants.LAMP.getAsString());
                }
                if (this.room.equals("GRAVITY") || this.room.equals("ANTIGRAVITY")) {
                    if (type.equals((Object)Material.PINK_WOOL)) {
                        String loc = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz).toString();
                        HashMap<String, Object> setd = new HashMap<String, Object>();
                        setd.put("tardis_id", this.tardis_id);
                        setd.put("location", loc);
                        setd.put("direction", 0);
                        setd.put("distance", 0);
                        setd.put("velocity", 0);
                        this.plugin.getQueryFactory().doInsert("gravity_well", setd);
                        this.plugin.getGeneralKeeper().getGravityDownList().add(loc);
                    }
                    if (type.equals((Object)Material.LIME_WOOL)) {
                        String loc = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz).toString();
                        HashMap<String, Object> setu = new HashMap<String, Object>();
                        setu.put("tardis_id", this.tardis_id);
                        setu.put("location", loc);
                        setu.put("direction", 1);
                        setu.put("distance", 16);
                        setu.put("velocity", 0.5);
                        this.plugin.getQueryFactory().doInsert("gravity_well", setu);
                        Double[] values = new Double[]{1.0, 16.0, 0.5};
                        this.plugin.getGeneralKeeper().getGravityUpList().put(loc, values);
                    }
                }
                if (this.room.equals("MAZE") && type.equals((Object)Material.STONE_PRESSURE_PLATE)) {
                    String loc_str = TARDISStaticLocationGetters.makeLocationStr(this.world, this.startx, this.starty, this.startz);
                    int maze = 40 + this.maze_count;
                    this.plugin.getQueryFactory().insertControl(this.tardis_id, maze, loc_str, 0);
                    ++this.maze_count;
                }
                if (this.room.equals("BAKER") || this.room.equals("WOOD")) {
                    int secondary = this.room.equals("BAKER") ? 1 : 2;
                    int r = 2;
                    List<Material> controls = List.of(Material.CAKE, Material.STONE_BUTTON, Material.MUSHROOM_STEM, Material.OAK_BUTTON);
                    if (controls.contains(type)) {
                        Object loc_str;
                        int control_type;
                        switch (type) {
                            case STONE_BUTTON: {
                                control_type = 1;
                                loc_str = TARDISStaticLocationGetters.makeLocationStr(this.world, this.startx, this.starty, this.startz);
                                break;
                            }
                            case MUSHROOM_STEM: {
                                control_type = this.repeaterOrder.get(r);
                                loc_str = this.world.getName() + ":" + this.startx + ":" + this.starty + ":" + this.startz;
                                Block rb = this.world.getBlockAt(this.startx, this.starty, this.startz);
                                this.mushroomblocks.put(rb, this.repeaterData[r]);
                                ++r;
                                break;
                            }
                            case OAK_BUTTON: {
                                control_type = 6;
                                loc_str = TARDISStaticLocationGetters.makeLocationStr(this.world, this.startx, this.starty, this.startz);
                                break;
                            }
                            default: {
                                control_type = 0;
                                loc_str = TARDISStaticLocationGetters.makeLocationStr(this.world, this.startx, this.starty, this.startz);
                            }
                        }
                        this.plugin.getQueryFactory().insertControl(this.tardis_id, control_type, (String)loc_str, secondary);
                    }
                }
                if (this.room.equals("ZERO") && type.equals((Object)Material.OAK_BUTTON)) {
                    String loc_str = TARDISStaticLocationGetters.makeLocationStr(this.world, this.startx, this.starty, this.startz);
                    this.plugin.getQueryFactory().insertControl(this.tardis_id, 17, loc_str, 0);
                }
                ++this.startz;
                ++this.col;
                if (this.col == this.c && this.row < this.w) {
                    this.col = 0;
                    this.startz = this.resetz;
                    ++this.startx;
                    ++this.row;
                }
                if (this.col == this.c && this.row == this.w && this.level < this.h) {
                    this.col = 0;
                    this.row = 0;
                    this.startx = this.resetx;
                    this.startz = this.resetz;
                    ++this.starty;
                    int percent = TARDISNumberParsers.roundUp(this.level * 100, this.h);
                    if (percent > 0) {
                        this.plugin.getBuildKeeper().getRoomProgress().put(this.uuid, percent);
                        if (this.player != null) {
                            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ROOM_PERCENT", this.room, String.format("%d", percent));
                        }
                    }
                    ++this.level;
                }
                rd.setRow(this.row);
                rd.setColumn(this.col);
                rd.setLevel(this.level);
                this.plugin.getTrackerKeeper().getRoomTasks().put(this.task, rd);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                this.plugin.getServer().getScheduler().cancelTask(this.task);
                this.task = 0;
                String string = "Resumption of room growing was aborted due to: " + e.getMessage();
                if (this.player != null) {
                    this.plugin.getMessenger().messageWithColour((CommandSender)this.player, string, "#FF5555");
                }
                this.plugin.debug(string);
            }
        }
    }

    private void turnOnFarming(Player p) {
        HashMap<String, Object> setpp = new HashMap<String, Object>();
        setpp.put("farm_on", 1);
        HashMap<String, Object> wherepp = new HashMap<String, Object>();
        wherepp.put("uuid", p.getUniqueId().toString());
        this.plugin.getQueryFactory().doUpdate("player_prefs", setpp, wherepp);
        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "PREF_WAS_ON", "Mob farming");
    }

    private boolean checkRoomNextDoor(Block b) {
        if (b.getLocation().getBlockZ() < this.resetz + 10 && !b.getRelative(BlockFace.EAST).getType().isAir()) {
            return true;
        }
        return !b.getRelative(BlockFace.SOUTH).getType().isAir();
    }

    public void setTask(int task) {
        this.task = task;
    }
}

