/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.schematic.actions.SchematicSave;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.entity.Entity;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.BoundingBox;

public class TARDISSchematicBuilder {
    private final TARDIS plugin;
    private final World w;
    private final int id;
    private final int sx;
    private final int ex;
    private final int sy;
    private final int ey;
    private final int sz;
    private final int ez;
    private final int[] controls = new int[]{0, 2, 3, 4, 5};
    private final HashMap<String, Material> mushroom_stem = new HashMap();
    private Location h;

    public TARDISSchematicBuilder(TARDIS plugin, int id, World w, int sx, int ex, int sy, int ey, int sz, int ez) {
        this.plugin = plugin;
        this.id = id;
        this.w = w;
        this.sx = sx;
        this.ex = ex;
        this.sy = sy;
        this.ey = ey;
        this.sz = sz;
        this.ez = ez;
        this.mushroom_stem.put("minecraft:mushroom_stem[down=true,east=false,north=true,south=true,up=true,west=true]", Material.ORANGE_WOOL);
        this.mushroom_stem.put("minecraft:mushroom_stem[down=true,east=true,north=false,south=true,up=true,west=true]", Material.BLUE_WOOL);
        this.mushroom_stem.put("minecraft:mushroom_stem[down=true,east=true,north=false,south=false,up=false,west=false]", Material.WHITE_STAINED_GLASS);
        this.mushroom_stem.put("minecraft:mushroom_stem[down=true,east=true,north=false,south=false,up=false,west=true]", Material.WHITE_TERRACOTTA);
    }

    public ArchiveData build() {
        boolean ars = true;
        HashMap<Integer, Location> map = new HashMap<Integer, Location>();
        block8: for (int c : this.controls) {
            HashMap<String, Object> whereh = new HashMap<String, Object>();
            whereh.put("tardis_id", this.id);
            whereh.put("type", c);
            ResultSetControls rsc = new ResultSetControls(this.plugin, whereh, false);
            if (!rsc.resultSet()) continue;
            Location location = TARDISStaticLocationGetters.getLocationFromDB(rsc.getLocation());
            switch (c) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    map.put(c, location);
                    continue block8;
                }
                default: {
                    this.h = TARDISStaticLocationGetters.getLocationFromBukkitString(rsc.getLocation());
                }
            }
        }
        HashMap<String, Object> whereb = new HashMap<String, Object>();
        whereb.put("tardis_id", this.id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, whereb, "", false);
        int bx = 0;
        int by = 0;
        int bz = 0;
        int cx = 0;
        int cy = 0;
        int cz = 0;
        if (rs.resultSet()) {
            String creeper;
            String beacon = rs.getTardis().getBeacon();
            if (!beacon.isEmpty()) {
                String[] split = beacon.split(":");
                bx = TARDISNumberParsers.parseInt(split[1]);
                by = TARDISNumberParsers.parseInt(split[2]);
                bz = TARDISNumberParsers.parseInt(split[3]);
            }
            if (!(creeper = rs.getTardis().getCreeper()).isEmpty()) {
                String[] csplit = creeper.split(":");
                cx = TARDISNumberParsers.parseInt(csplit[1].substring(0, csplit[1].length() - 2));
                cy = TARDISNumberParsers.parseInt(csplit[2]);
                cz = TARDISNumberParsers.parseInt(csplit[3].substring(0, csplit[3].length() - 2));
            }
        }
        int minx = Math.min(this.sx, this.ex);
        int maxx = Math.max(this.sx, this.ex);
        int miny = Math.min(this.sy, this.ey);
        int maxy = Math.max(this.sy, this.ey);
        int minz = Math.min(this.sz, this.ez);
        int maxz = Math.max(this.sz, this.ez);
        JsonObject relative = new JsonObject();
        relative.addProperty("x", (Number)maxx);
        relative.addProperty("y", (Number)miny);
        relative.addProperty("z", (Number)(minz - 1));
        JsonObject dimensions = new JsonObject();
        int width = maxx - minx + 1;
        int height = maxy - miny + 1;
        int length = maxz - minz + 1;
        dimensions.addProperty("width", (Number)width);
        dimensions.addProperty("height", (Number)height);
        dimensions.addProperty("length", (Number)length);
        JsonArray paintings = new JsonArray();
        JsonArray itemFrames = new JsonArray();
        JsonArray itemDisplays = new JsonArray();
        JsonArray interactions = new JsonArray();
        ArrayList<Entity> entities = new ArrayList<Entity>();
        JsonArray levels = new JsonArray();
        int f = 2;
        int beacon = 0;
        for (int l = miny; l <= maxy; ++l) {
            JsonArray rows = new JsonArray();
            for (int r = minx; r <= maxx; ++r) {
                JsonArray columns = new JsonArray();
                for (int c = minz; c <= maxz; ++c) {
                    JsonObject obj = new JsonObject();
                    Block b = this.w.getBlockAt(r, l, c);
                    Location location = b.getLocation();
                    BoundingBox box = new BoundingBox((double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ(), (double)(location.getBlockX() + 1), (double)(location.getBlockY() + 1), (double)(location.getBlockZ() + 1));
                    for (Entity entity : b.getLocation().getWorld().getNearbyEntities(box)) {
                        JsonElement element;
                        ItemMeta im;
                        JsonObject loc;
                        Location eloc = entity.getLocation();
                        if (entity instanceof Painting) {
                            Painting art = (Painting)entity;
                            if (!entities.contains(entity)) {
                                JsonObject painting = new JsonObject();
                                loc = new JsonObject();
                                loc.addProperty("x", (Number)(eloc.getBlockX() - minx));
                                loc.addProperty("y", (Number)(eloc.getBlockY() - miny));
                                loc.addProperty("z", (Number)(eloc.getBlockZ() - minz));
                                painting.add("rel_location", (JsonElement)loc);
                                painting.addProperty("art", art.getArt().toString());
                                painting.addProperty("facing", art.getFacing().toString());
                                paintings.add((JsonElement)painting);
                                entities.add(entity);
                            }
                        }
                        if (entity instanceof ItemFrame) {
                            ItemFrame fr = (ItemFrame)entity;
                            if (!entities.contains(entity)) {
                                JsonObject frame = new JsonObject();
                                loc = new JsonObject();
                                loc.addProperty("x", (Number)(eloc.getBlockX() - minx));
                                loc.addProperty("y", (Number)(eloc.getBlockY() - miny));
                                loc.addProperty("z", (Number)(eloc.getBlockZ() - minz));
                                frame.add("rel_location", (JsonElement)loc);
                                frame.addProperty("facing", fr.getFacing().toString());
                                ItemStack item = fr.getItem();
                                Material type = item.getType();
                                if (!type.isAir()) {
                                    frame.addProperty("item", type.toString());
                                    if (item.hasItemMeta()) {
                                        im = item.getItemMeta();
                                        if (im.hasItemModel()) {
                                            frame.addProperty("cmd", im.getItemModel().getKey());
                                        }
                                        if (im.hasDisplayName()) {
                                            element = ComponentUtils.getJson(im.displayName());
                                            this.plugin.debug(element.toString());
                                            frame.add("name", element);
                                        }
                                        if (im.hasLore()) {
                                            JsonArray lore = new JsonArray();
                                            for (Component s : im.lore()) {
                                                lore.add(ComponentUtils.stripColour(s));
                                            }
                                            frame.add("lore", (JsonElement)lore);
                                        }
                                        if ((Tag.ITEMS_BANNERS.isTagged((Keyed)type) || type == Material.SHIELD) && im instanceof BlockStateMeta) {
                                            BlockStateMeta bsm = (BlockStateMeta)im;
                                            JsonObject state = SchematicSave.getBannerJson(bsm.getBlockState());
                                            frame.add("banner", (JsonElement)state);
                                        }
                                    }
                                }
                                frame.addProperty("fixed", Boolean.valueOf(fr.isFixed()));
                                frame.addProperty("visible", Boolean.valueOf(fr.isVisible()));
                                frame.addProperty("rotation", fr.getRotation().toString());
                                frame.addProperty("glowing", Boolean.valueOf(fr instanceof GlowItemFrame));
                                itemFrames.add((JsonElement)frame);
                                entities.add(entity);
                            }
                        }
                        if (entity instanceof ItemDisplay) {
                            ItemDisplay display = (ItemDisplay)entity;
                            if (!entities.contains(entity)) {
                                JsonObject item = new JsonObject();
                                loc = new JsonObject();
                                loc.addProperty("x", (Number)(eloc.getBlockX() - minx));
                                loc.addProperty("y", (Number)(eloc.getBlockY() - miny));
                                loc.addProperty("z", (Number)(eloc.getBlockZ() - minz));
                                item.add("rel_location", (JsonElement)loc);
                                JsonObject stack = new JsonObject();
                                Material material = display.getItemStack().getType();
                                im = display.getItemStack().getItemMeta();
                                stack.addProperty("type", material.toString());
                                if (im.hasItemModel()) {
                                    NamespacedKey model = im.getItemModel();
                                    stack.addProperty("cmd", model.getKey());
                                    TARDISDisplayItem tdi = TARDISDisplayItem.getByModel(model);
                                    if (tdi != null) {
                                        stack.addProperty("light", Boolean.valueOf(tdi.isLight()));
                                        stack.addProperty("lit", Boolean.valueOf(tdi.isLit()));
                                    }
                                }
                                if (im.hasDisplayName()) {
                                    element = ComponentUtils.getJson(im.displayName());
                                    stack.add("name", element);
                                }
                                item.add("stack", (JsonElement)stack);
                                itemDisplays.add((JsonElement)item);
                                entities.add(entity);
                            }
                        }
                        if (!(entity instanceof Interaction)) continue;
                        Interaction interaction = (Interaction)entity;
                        if (entities.contains(entity)) continue;
                        JsonObject inter = new JsonObject();
                        loc = new JsonObject();
                        loc.addProperty("x", (Number)(eloc.getBlockX() - minx));
                        loc.addProperty("y", (Number)(eloc.getBlockY() - miny));
                        loc.addProperty("z", (Number)(eloc.getBlockZ() - minz));
                        inter.add("rel_location", (JsonElement)loc);
                        JsonObject bounds = new JsonObject();
                        bounds.addProperty("height", (Number)Float.valueOf(interaction.getInteractionHeight()));
                        bounds.addProperty("width", (Number)Float.valueOf(interaction.getInteractionWidth()));
                        inter.add("bounds", (JsonElement)bounds);
                        interactions.add((JsonElement)inter);
                        entities.add(entity);
                    }
                    BlockData data = b.getBlockData();
                    Material m = data.getMaterial();
                    if (ars && m.isAir()) {
                        data = Material.INFESTED_COBBLESTONE.createBlockData();
                        ars = false;
                    }
                    switch (m) {
                        case REPEATER: {
                            if (!this.isControlBlock((Location)map.get(f), this.w, r, l, c)) break;
                            MultipleFacing mushroom = (MultipleFacing)Material.MUSHROOM_STEM.createBlockData();
                            mushroom.setFace(BlockFace.DOWN, true);
                            mushroom.setFace(BlockFace.EAST, true);
                            mushroom.setFace(BlockFace.NORTH, true);
                            mushroom.setFace(BlockFace.SOUTH, true);
                            mushroom.setFace(BlockFace.UP, true);
                            mushroom.setFace(BlockFace.WEST, true);
                            data = mushroom;
                            ++f;
                            break;
                        }
                        case LEVER: {
                            if (!this.isControlBlock(this.h, this.w, r, l, c)) break;
                            data = Material.CAKE.createBlockData();
                            break;
                        }
                        case MUSHROOM_STEM: {
                            if (!this.mushroom_stem.containsKey(data.getAsString())) break;
                            data = this.mushroom_stem.get(data.getAsString()).createBlockData();
                            break;
                        }
                    }
                    if (bx != 0 && l == by && r == bx && c == bz) {
                        data = Material.BEDROCK.createBlockData();
                    }
                    if (cx != 0 && l == cy && r == cx && c == cz) {
                        data = m.equals((Object)Material.BEACON) ? Material.BEACON.createBlockData() : Material.COMMAND_BLOCK.createBlockData();
                        beacon = m.equals((Object)Material.BEACON) ? 1 : 0;
                    }
                    obj.addProperty("data", data.getAsString());
                    if (TARDISStaticUtils.isBanner(m)) {
                        JsonObject state = SchematicSave.getBannerJson(b.getState());
                        obj.add("banner", (JsonElement)state);
                    }
                    if (m.equals((Object)Material.PLAYER_HEAD) || m.equals((Object)Material.PLAYER_WALL_HEAD)) {
                        JsonObject head = new JsonObject();
                        Skull skull = (Skull)b.getState();
                        if (skull.getPlayerProfile() != null) {
                            String name = Objects.requireNonNullElse(skull.getPlayerProfile().getName(), "");
                            head.addProperty("uuid", skull.getPlayerProfile().getUniqueId().toString());
                            head.addProperty("name", name);
                            head.addProperty("texture", skull.getPlayerProfile().getTextures().getSkin().toString());
                        }
                        obj.add("head", (JsonElement)head);
                    }
                    columns.add((JsonElement)obj);
                }
                rows.add((JsonElement)columns);
            }
            levels.add((JsonElement)rows);
        }
        JsonObject schematic = new JsonObject();
        schematic.add("relative", (JsonElement)relative);
        schematic.add("dimensions", (JsonElement)dimensions);
        schematic.add("input", (JsonElement)levels);
        if (!paintings.isEmpty()) {
            schematic.add("paintings", (JsonElement)paintings);
        }
        if (!itemFrames.isEmpty()) {
            schematic.add("item_frames", (JsonElement)itemFrames);
        }
        if (!itemDisplays.isEmpty()) {
            schematic.add("item_displays", (JsonElement)itemDisplays);
        }
        if (!interactions.isEmpty()) {
            schematic.add("interactions", (JsonElement)interactions);
        }
        return new ArchiveData(schematic, beacon);
    }

    private boolean isControlBlock(Location l, World w, int x, int y, int z) {
        Location n = new Location(w, (double)x, (double)y, (double)z);
        return n.equals((Object)l);
    }

    public static class ArchiveData {
        private final JsonObject JSON;
        private final int beacon;

        ArchiveData(JsonObject JSON, int beacon) {
            this.JSON = JSON;
            this.beacon = beacon;
        }

        public JsonObject getJSON() {
            return this.JSON;
        }

        public int getBeacon() {
            return this.beacon;
        }
    }
}

