/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.toclafane;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.custommodels.keys.ToclafaneVariant;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.nms.TWAFollower;
import me.eccentric_nz.tardisweepingangels.utils.WorldGuardChecker;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Husk;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ToclafaneListener
implements Listener {
    private final TARDIS plugin;
    private final List<Material> drops = new ArrayList<Material>();

    public ToclafaneListener(TARDIS plugin) {
        this.plugin = plugin;
        plugin.getMonstersConfig().getStringList("toclafane.drops").forEach(d -> this.drops.add(Material.valueOf((String)d)));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onDamageToclafane(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        Entity damager = event.getDamager();
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArmorStand.class, Bee.class, Player.class}, (Object)entity3, n)) {
                case 0: {
                    ArmorStand stand = (ArmorStand)entity3;
                    if (!(damager instanceof Player)) {
                        n = 1;
                        continue block5;
                    }
                    Player player = (Player)damager;
                    if (!stand.getPersistentDataContainer().has(TARDISWeepingAngels.TOCLAFANE, PersistentDataType.INTEGER)) break block5;
                    event.setCancelled(true);
                    int maxHealth = stand.getLocation().getWorld().getDifficulty().ordinal() * 6 + 1;
                    int health = (Integer)stand.getPersistentDataContainer().get(TARDISWeepingAngels.TOCLAFANE, PersistentDataType.INTEGER);
                    if (health == maxHealth) {
                        EntityEquipment ee;
                        Bee bee = (Bee)stand.getVehicle();
                        if (bee == null) {
                            bee = (Bee)stand.getLocation().getWorld().spawnEntity(stand.getLocation(), EntityType.BEE);
                            PotionEffect p = new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, true, false);
                            bee.addPotionEffect(p);
                            bee.addPassenger((Entity)stand);
                        }
                        if ((ee = stand.getEquipment()) == null) break block5;
                        ItemStack head = ee.getHelmet();
                        ItemMeta im = head.getItemMeta();
                        player.playSound(stand.getLocation(), "toclafane", 1.0f, 1.0f);
                        im.setItemModel(ToclafaneVariant.TOCLAFANE_ATTACK.getKey());
                        head.setItemMeta(im);
                        ee.setHelmet(head);
                        bee.setHasStung(false);
                        bee.setHealth(bee.getAttribute(Attribute.MAX_HEALTH).getValue());
                        bee.setAnger(500);
                        bee.setTarget((LivingEntity)player);
                        bee.setSilent(true);
                        stand.getPersistentDataContainer().set(TARDISWeepingAngels.TOCLAFANE, PersistentDataType.INTEGER, (Object)(maxHealth - 1));
                        break block5;
                    }
                    player.playSound(stand.getLocation(), "dalek_hit", 1.0f, 1.0f);
                    if (--health == 0) {
                        Location location = stand.getLocation();
                        if (stand.getVehicle() != null) {
                            Entity bee = stand.getVehicle();
                            if (bee instanceof Bee) {
                                stand.remove();
                                bee.remove();
                            }
                        } else {
                            stand.remove();
                        }
                        boolean destroy = this.plugin.getServer().getPluginManager().isPluginEnabled("WorldGuard") ? this.plugin.getMonstersConfig().getBoolean("toclafane.destroy_blocks") && WorldGuardChecker.canExplode(location) : this.plugin.getMonstersConfig().getBoolean("toclafane.destroy_blocks");
                        location.getWorld().createExplosion(location, 2.0f, false, destroy);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            ItemStack stack = ItemStack.of((Material)this.drops.get(TARDISConstants.RANDOM.nextInt(this.drops.size())), (int)(TARDISConstants.RANDOM.nextInt(1) + 1));
                            location.getWorld().dropItemNaturally(location, stack);
                        }, 3L);
                        break block5;
                    }
                    stand.getPersistentDataContainer().set(TARDISWeepingAngels.TOCLAFANE, PersistentDataType.INTEGER, (Object)health);
                    break block5;
                }
                case 1: {
                    Entity passenger;
                    Bee bee = (Bee)entity3;
                    if (entity.getPassengers().isEmpty() || !((passenger = (Entity)entity.getPassengers().getFirst()) instanceof ArmorStand) || !passenger.getPersistentDataContainer().has(TARDISWeepingAngels.TOCLAFANE, PersistentDataType.INTEGER)) break block5;
                    bee.setHasStung(false);
                    break block5;
                }
                case 2: {
                    Entity passenger;
                    Player player = (Player)entity3;
                    if (!(damager instanceof Bee)) {
                        n = 3;
                        continue block5;
                    }
                    Bee bee = (Bee)damager;
                    if (damager.getPassengers().isEmpty() || !((passenger = (Entity)damager.getPassengers().getFirst()) instanceof ArmorStand) || !passenger.getPersistentDataContainer().has(TARDISWeepingAngels.TOCLAFANE, PersistentDataType.INTEGER)) break block5;
                    bee.setHasStung(false);
                    bee.setHealth(bee.getAttribute(Attribute.MAX_HEALTH).getValue());
                    bee.setTarget((LivingEntity)player);
                    break block5;
                }
            }
            break;
        }
    }

    @EventHandler
    public void onBeeAndGolemTargetEvent(EntityTargetEvent event) {
        Entity passenger;
        Bee bee;
        Entity entity = event.getEntity();
        if (entity instanceof Bee && ((bee = (Bee)entity).getTarget() instanceof Player || bee.getAnger() >= 0) && !bee.getPassengers().isEmpty() && (passenger = (Entity)bee.getPassengers().getFirst()) instanceof ArmorStand && passenger.getPersistentDataContainer().has(TARDISWeepingAngels.TOCLAFANE, PersistentDataType.INTEGER)) {
            bee.setHasStung(false);
        }
        if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            LivingEntity livingEntity = golem.getTarget();
            if (!(livingEntity instanceof Husk)) {
                return;
            }
            Husk husk = (Husk)livingEntity;
            if (((CraftEntity)husk).getHandle() instanceof TWAFollower) {
                event.setCancelled(true);
            }
        }
    }
}

