/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.utils;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Follower;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetFollowers;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.equip.MonsterEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.empty_child.EmptyChildEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.headless_monks.HeadlessFlameRunnable;
import me.eccentric_nz.tardisweepingangels.monsters.headless_monks.HeadlessMonkEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.judoon.JudoonEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.k9.K9Equipment;
import me.eccentric_nz.tardisweepingangels.monsters.ood.OodEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.silent.SilentEquipment;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.nms.TWAFollower;
import me.eccentric_nz.tardisweepingangels.nms.TWAJudoon;
import me.eccentric_nz.tardisweepingangels.nms.TWAK9;
import me.eccentric_nz.tardisweepingangels.nms.TWAOod;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ResetMonster {
    private final TARDIS plugin;
    private final Entity entity;

    public ResetMonster(TARDIS plugin, Entity entity) {
        this.plugin = plugin;
        this.entity = entity;
    }

    public void reset() {
        Monster monster = MonsterEquipment.getMonsterType(this.entity);
        if (monster == null || monster.isFollower()) {
            return;
        }
        Location location = this.entity.getLocation();
        PersistentDataContainer pdc = this.entity.getPersistentDataContainer();
        LivingEntity a = null;
        OfflinePlayer player = null;
        if (monster.isFollower()) {
            ResultSetFollowers rsf;
            Follower follower = null;
            UUID eid = null;
            if (pdc.has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), TARDISWeepingAngels.PersistentDataTypeUUID)) {
                eid = (UUID)pdc.get(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), TARDISWeepingAngels.PersistentDataTypeUUID);
            }
            if (eid != null && (rsf = new ResultSetFollowers(this.plugin, eid.toString())).resultSet()) {
                follower = rsf.getEntity();
                a = (LivingEntity)new MonsterSpawner().createFollower(location, follower).getBukkitEntity();
            }
            if (a == null || this.entity.getType() == EntityType.ARMOR_STAND) {
                UUID uuid = TARDISWeepingAngels.UNCLAIMED;
                if (pdc.has(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID)) {
                    uuid = (UUID)pdc.get(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID);
                }
                this.plugin.setTardisSpawn(true);
                a = (LivingEntity)new MonsterSpawner().createFollower(this.entity.getLocation(), new Follower(UUID.randomUUID(), uuid, monster)).getBukkitEntity();
            }
            if (follower != null) {
                if (monster == Monster.OOD) {
                    TWAOod ood = (TWAOod)((CraftEntity)a).getHandle();
                    ood.setColour(follower.getColour());
                    ood.setRedeye(follower.hasOption());
                    ood.setFollowing(follower.isFollowing());
                } else if (monster == Monster.JUDOON) {
                    TWAJudoon judoon = (TWAJudoon)((CraftEntity)a).getHandle();
                    judoon.setAmmo(follower.getAmmo());
                    judoon.setGuard(follower.hasOption());
                    judoon.setFollowing(follower.isFollowing());
                    if (follower.hasOption()) {
                        TARDISWeepingAngels.getGuards().add(a.getUniqueId());
                        TARDISWeepingAngels.getPlayersWithGuards().add(judoon.getOwnerUUID());
                    }
                } else if (monster == Monster.K9) {
                    TWAK9 k9 = (TWAK9)((CraftEntity)a).getHandle();
                    k9.setFollowing(follower.isFollowing());
                }
                TWAFollower twaf = (TWAFollower)((CraftEntity)a).getHandle();
                twaf.setOwnerUUID(follower.getOwner());
                a.getPersistentDataContainer().set(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID, (Object)follower.getOwner());
                player = this.plugin.getServer().getOfflinePlayer(follower.getOwner());
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", eid.toString());
                this.plugin.getQueryFactory().doDelete("followers", where);
            }
        } else {
            this.plugin.setTardisSpawn(true);
            a = new MonsterSpawner().create(location, monster);
        }
        this.entity.remove();
        if (monster.isFollower()) {
            Husk husk = (Husk)a;
            switch (monster) {
                case K9: {
                    K9Equipment.set(player, a, false);
                    break;
                }
                case JUDOON: {
                    JudoonEquipment.set(player, (LivingEntity)husk, false);
                    break;
                }
                default: {
                    OodEquipment.set(player, a, false);
                    break;
                }
            }
        } else {
            if (monster != Monster.DALEK) {
                new Equipper(monster, a, false).setHelmetAndInvisibility();
            }
            switch (monster) {
                case EMPTY_CHILD: {
                    EmptyChildEquipment.setSpeed(a);
                    break;
                }
                case HEADLESS_MONK: {
                    HeadlessMonkEquipment.setTasks(a);
                    int flameID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new HeadlessFlameRunnable(a), 1L, 20L);
                    a.getPersistentDataContainer().set(TARDISWeepingAngels.FLAME_TASK, PersistentDataType.INTEGER, (Object)flameID);
                    break;
                }
                case ICE_WARRIOR: {
                    PigZombie pigman = (PigZombie)a;
                    pigman.setAngry(true);
                    pigman.setAnger(Integer.MAX_VALUE);
                    break;
                }
                case SILENT: {
                    SilentEquipment.setGuardian(a);
                    break;
                }
                case STRAX: {
                    PigZombie strax = (PigZombie)a;
                    strax.setAngry(false);
                    a.customName((Component)Component.text((String)"Strax"));
                    break;
                }
            }
        }
    }
}

