/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.preferences;

import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetParticlePrefs;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.particles.ParticleEffect;
import me.eccentric_nz.TARDIS.particles.ParticleShape;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISParticlePrefsCommand {
    private final TARDIS plugin;

    public TARDISParticlePrefsCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean setPartclePref(Player player, String[] args) {
        Object value;
        String which;
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return true;
        }
        switch (which = args[0].toLowerCase(Locale.ROOT)) {
            case "effect": {
                try {
                    ParticleEffect effect = ParticleEffect.valueOf(args[1].toUpperCase(Locale.ROOT));
                    value = effect.toString();
                    break;
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_PARTICLE", args[1], "effect");
                    return true;
                }
            }
            case "shape": {
                try {
                    ParticleShape shape = ParticleShape.valueOf(args[1].toUpperCase(Locale.ROOT));
                    value = shape.toString();
                    break;
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_PARTICLE", args[1], "shape");
                    return true;
                }
            }
            default: {
                value = TARDISNumberParsers.parseDouble(args[1]);
                if ((Double)value != -1.0) break;
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_PARTICLE", args[1], "speed");
                return true;
            }
        }
        String uuid = player.getUniqueId().toString();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put(which, value);
        ResultSetParticlePrefs rss = new ResultSetParticlePrefs(this.plugin);
        if (rss.fromUUID(uuid)) {
            HashMap<String, Object> wherea = new HashMap<String, Object>();
            wherea.put("uuid", uuid);
            this.plugin.getQueryFactory().doUpdate("particle_prefs", set, wherea);
        } else {
            set.put("uuid", uuid);
            this.plugin.getQueryFactory().doInsert("particle_prefs", set);
        }
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PARTICLE_SAVED");
        return true;
    }
}

