/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;

public class TARDISDatabaseConnection {
    private static final TARDISDatabaseConnection INSTANCE = new TARDISDatabaseConnection();
    public Connection connection = null;
    private boolean isMySQL;

    public static synchronized TARDISDatabaseConnection getINSTANCE() {
        return INSTANCE;
    }

    void setIsMySQL(boolean isMySQL) {
        this.isMySQL = isMySQL;
    }

    public boolean isMySQL() {
        return this.isMySQL;
    }

    public void setConnection() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find the driver in the classpath!", e);
        }
        String jdbc = "jdbc:mysql://" + TARDIS.plugin.getConfig().getString("storage.mysql.host") + ":" + TARDIS.plugin.getConfig().getString("storage.mysql.port") + "/" + TARDIS.plugin.getConfig().getString("storage.mysql.database") + "?autoReconnect=true";
        if (!TARDIS.plugin.getConfig().getBoolean("storage.mysql.useSSL")) {
            jdbc = jdbc + "&useSSL=false";
        }
        String user = TARDIS.plugin.getConfig().getString("storage.mysql.user");
        String pass = TARDIS.plugin.getConfig().getString("storage.mysql.password");
        try {
            this.connection = DriverManager.getConnection(jdbc, user, pass);
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot connect the database! ", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(String path) throws Exception {
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + path);
        this.connection.setAutoCommit(true);
        Statement statement = this.connection.createStatement();
        statement.execute("PRAGMA auto_vacuum = FULL;");
        statement.close();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Clone is not allowed.");
    }

    public void testConnection(Connection connection) {
        try {
            if (this.isMySQL && !connection.isValid(1)) {
                this.setConnection();
            }
        }
        catch (SQLException ex) {
            TARDIS.plugin.debug("Could not re-connect to database! " + ex.getMessage());
        }
    }
}

