/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import org.bukkit.command.CommandSender;

public class TARDISGroupManagerHandler {
    private final TARDIS plugin;
    private final File permissionsFile;
    private final LinkedHashMap<String, List<String>> permgroups = new LinkedHashMap();
    private String group;

    public TARDISGroupManagerHandler(TARDIS plugin) {
        this.plugin = plugin;
        this.permissionsFile = new File(plugin.getDataFolder(), "permissions.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPerms(String player) {
        BufferedReader bufRdr = null;
        try {
            String line;
            bufRdr = new BufferedReader(new FileReader(this.permissionsFile));
            while ((line = bufRdr.readLine()) != null) {
                if (line.charAt(0) == '#') {
                    this.group = line.substring(1).trim();
                    this.permgroups.put(this.group, new ArrayList());
                    continue;
                }
                List<String> perms = this.permgroups.get(this.group);
                perms.add(line.trim());
            }
        }
        catch (IOException io) {
            this.plugin.debug("Could not read perms file. " + io.getMessage());
        }
        finally {
            if (bufRdr != null) {
                try {
                    bufRdr.close();
                }
                catch (IOException e) {
                    this.plugin.debug("Error closing perms reader! " + e.getMessage());
                }
            }
        }
        if (TARDISFloodgate.shouldReplacePrefix(player)) {
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "manselect " + TARDISFloodgate.getPlayerWorldName(player));
        } else {
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "manselect TARDIS_WORLD_" + player);
        }
        int i = 0;
        for (Map.Entry<String, List<String>> entry : this.permgroups.entrySet()) {
            String grpstr = entry.getKey();
            List<String> perms = entry.getValue();
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "mangadd " + grpstr);
            perms.forEach(p -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "mangaddp " + grpstr + " " + p));
            if (i == 0) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "manuadd " + player + " " + grpstr);
            }
            ++i;
        }
        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "mansave");
    }
}

