/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.shell;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonPresets;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetShells;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class TARDISShellInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final int id;
    private final Inventory inventory;

    public TARDISShellInventory(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS Shells", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stacks = new ItemStack[54];
        HashMap<String, Object> wherec = new HashMap<String, Object>();
        wherec.put("tardis_id", this.id);
        ResultSetShells rss = new ResultSetShells(this.plugin, wherec);
        if (rss.resultSet()) {
            int i = 0;
            ArrayList<HashMap<String, String>> data = rss.getData();
            for (HashMap<String, String> map : data) {
                Material material = null;
                String blueprint = map.get("blueprintData");
                JsonArray json = JsonParser.parseString((String)blueprint).getAsJsonArray();
                block1: for (int k = 0; k < 10; ++k) {
                    JsonArray inner = json.get(k).getAsJsonArray();
                    for (int j = 0; j < 4; ++j) {
                        String block = inner.get(j).getAsString();
                        if (block.equals("minecraft:air")) continue;
                        BlockData blockData = this.plugin.getServer().createBlockData(block);
                        material = blockData.getMaterial();
                        break block1;
                    }
                }
                if (material == null) {
                    material = GUIChameleonPresets.SAVED.material();
                }
                ItemStack saved = ItemStack.of((Material)material, (int)1);
                ItemMeta con = saved.getItemMeta();
                con.displayName((Component)Component.text((String)"Saved Construct"));
                ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                lore.add(Component.text((String)map.get("line1")));
                lore.add(Component.text((String)map.get("line2")));
                lore.add(Component.text((String)map.get("line3")));
                lore.add(Component.text((String)map.get("line4")));
                if (map.get("active").equals("1")) {
                    lore.add(Component.text((String)"Active shell", (TextColor)NamedTextColor.AQUA));
                }
                con.lore(lore);
                con.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER, (Object)TARDISNumberParsers.parseInt(map.get("chameleon_id")));
                saved.setItemMeta(con);
                stacks[i] = saved;
                if (++i <= 44) continue;
                break;
            }
        }
        ItemStack use = ItemStack.of((Material)GUIChameleonPresets.USE_SELECTED.material(), (int)1);
        ItemMeta uim = use.getItemMeta();
        uim.displayName((Component)Component.text((String)"Use selected shell"));
        uim.lore(List.of(Component.text((String)"Will apply shell to"), Component.text((String)"the Chameleon Circuit"), Component.text((String)"and rebuild the exterior.")));
        use.setItemMeta(uim);
        stacks[GUIChameleonPresets.USE_SELECTED.slot()] = use;
        ItemStack delete = ItemStack.of((Material)GUIChameleonPresets.DELETE_SELECTED.material(), (int)1);
        ItemMeta dim = delete.getItemMeta();
        dim.displayName((Component)Component.text((String)"Delete selected shell"));
        delete.setItemMeta(dim);
        stacks[GUIChameleonPresets.DELETE_SELECTED.slot()] = delete;
        ItemStack update = ItemStack.of((Material)GUIChameleonPresets.UPDATE_SELECTED.material(), (int)1);
        ItemMeta upim = update.getItemMeta();
        upim.displayName((Component)Component.text((String)"Update selected shell"));
        update.setItemMeta(upim);
        stacks[GUIChameleonPresets.UPDATE_SELECTED.slot()] = update;
        ItemStack newShell = ItemStack.of((Material)GUIChameleonPresets.NEW.material(), (int)1);
        ItemMeta ns = newShell.getItemMeta();
        ns.displayName((Component)Component.text((String)"New Chameleon shell"));
        ns.lore(List.of(Component.text((String)"Will clear the shell platform"), Component.text((String)"ready for building.")));
        newShell.setItemMeta(ns);
        stacks[GUIChameleonPresets.NEW.slot()] = newShell;
        ItemStack save = ItemStack.of((Material)GUIChameleonPresets.SAVE.material(), (int)1);
        ItemMeta pre = save.getItemMeta();
        pre.displayName((Component)Component.text((String)"Save Chameleon shell"));
        ns.lore(List.of(Component.text((String)"Will save shell and"), Component.text((String)"rebuild the exterior.")));
        save.setItemMeta(pre);
        stacks[GUIChameleonPresets.SAVE.slot()] = save;
        ItemStack close = ItemStack.of((Material)GUIChameleonPresets.CLOSE.material(), (int)1);
        ItemMeta can = close.getItemMeta();
        can.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(can);
        stacks[GUIChameleonPresets.CLOSE.slot()] = close;
        return stacks;
    }
}

