/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.bind;

import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.bind.BindAdd;
import me.eccentric_nz.TARDIS.commands.bind.BindRemove;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.Bind;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISBindCommands
implements CommandExecutor {
    private final TARDIS plugin;

    public TARDISBindCommands(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisbind")) {
            Bind bind;
            if (!TARDISPermission.hasPermission(sender, "tardis.update")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                return false;
            }
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (player == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                return false;
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                new TARDISCommandHelper(this.plugin).getCommand("tardisbind", sender);
                return false;
            }
            try {
                bind = Bind.valueOf(args[1].toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIND_NOT_VALID");
                return false;
            }
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return false;
            }
            int id = rs.getTardisId();
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("uuid", player.getUniqueId().toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
            if (!rst.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_TARDIS");
                return false;
            }
            if (args[0].equalsIgnoreCase("add")) {
                if (args.length < bind.getArgs()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                    return false;
                }
                return new BindAdd(this.plugin).setClick(bind, player, id, args);
            }
            if (args[0].equalsIgnoreCase("remove")) {
                return new BindRemove(this.plugin).setClick(bind, player);
            }
        }
        return false;
    }
}

