/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.rooms.TARDISPainting;
import me.eccentric_nz.TARDIS.schematic.getters.DataPackPainting;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISBannerSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISHeadSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISItemDisplaySetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISItemFrameSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISPotSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISSignSetter;
import me.eccentric_nz.TARDIS.utility.TARDISBannerData;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import org.bukkit.Art;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISDevRoomPaster
implements Runnable {
    private final TARDIS plugin;
    private final Player player;
    private final HashMap<Block, BlockData> postRedstoneTorches = new HashMap();
    private final HashMap<Block, BlockData> postRedstoneDust = new HashMap();
    private final HashMap<Block, BlockData> postPistons = new HashMap();
    private final HashMap<Block, TARDISBannerData> postBanners = new HashMap();
    private final JsonObject json;
    private final Location location;
    private int task;
    private int l;
    private int r;
    private int h;
    private int w;
    private int d;
    private int x;
    private int y;
    private int z;
    private World world;
    private JsonArray arr;
    private boolean running = false;

    public TARDISDevRoomPaster(TARDIS plugin, Player player, JsonObject json, Location location) {
        this.plugin = plugin;
        this.player = player;
        this.l = 0;
        this.r = 0;
        this.json = json;
        this.location = location;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        if (this.json == null) {
            this.plugin.debug("Schematic was null!");
            return;
        }
        if (!this.running) {
            JsonObject dimensions = this.json.get("dimensions").getAsJsonObject();
            this.h = dimensions.get("height").getAsInt() - 1;
            this.w = dimensions.get("width").getAsInt();
            this.d = dimensions.get("length").getAsInt() - 1;
            JsonObject jsonObject = this.json.get("relative").getAsJsonObject();
            int rx = jsonObject.get("x").getAsInt();
            int ry = jsonObject.get("y").getAsInt();
            int rz = jsonObject.get("z").getAsInt();
            this.x = this.location.getBlockX() - rx;
            this.y = this.location.getBlockY() - ry;
            this.z = this.location.getBlockZ() - rz;
            this.world = this.player.getWorld();
            this.arr = this.json.get("input").getAsJsonArray();
            this.running = true;
        }
        if (this.l == this.h && this.r == this.w - 1) {
            int i;
            for (Map.Entry entry : this.postRedstoneTorches.entrySet()) {
                ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement((Block)entry.getKey());
            }
            for (Map.Entry entry : this.postRedstoneDust.entrySet()) {
                ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement((Block)entry.getKey());
            }
            for (Map.Entry entry : this.postPistons.entrySet()) {
                ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement((Block)entry.getKey());
            }
            TARDISBannerSetter.setBanners(this.postBanners);
            if (this.json.has("paintings")) {
                void var2_10;
                JsonArray paintings = this.json.get("paintings").getAsJsonArray();
                boolean bl = false;
                while (var2_10 < paintings.size()) {
                    JsonObject painting = paintings.get((int)var2_10).getAsJsonObject();
                    JsonObject rel = painting.get("rel_location").getAsJsonObject();
                    int px = rel.get("x").getAsInt();
                    int py = rel.get("y").getAsInt();
                    int pz = rel.get("z").getAsInt();
                    BlockFace facing = BlockFace.valueOf((String)painting.get("facing").getAsString());
                    Location pl = null;
                    String which = painting.get("art").getAsString();
                    Art art = null;
                    if (which.contains(":")) {
                        pl = TARDISPainting.calculatePosition(which.split(":")[1], facing, new Location(this.world, (double)(this.x + px), (double)(this.y + py), (double)(this.z + pz)));
                    } else {
                        art = (Art)RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT).get(new NamespacedKey("minecraft", which.toLowerCase(Locale.ROOT)));
                        if (art != null) {
                            pl = TARDISPainting.calculatePosition(art, facing, new Location(this.world, (double)(this.x + px), (double)(this.y + py), (double)(this.z + pz)));
                        }
                    }
                    if (pl != null) {
                        try {
                            Painting ent = (Painting)this.world.spawnEntity(pl, EntityType.PAINTING);
                            ent.teleport(pl);
                            ent.setFacingDirection(facing, true);
                            if (art != null) {
                                ent.setArt(art, true);
                            } else {
                                DataPackPainting.setCustomVariant(ent, which);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.debug("Invalid painting location!" + String.valueOf(pl));
                        }
                    }
                    ++var2_10;
                }
            }
            Location start = new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
            if (this.json.has("item_frames")) {
                JsonArray jsonArray = this.json.get("item_frames").getAsJsonArray();
                for (i = 0; i < jsonArray.size(); ++i) {
                    TARDISItemFrameSetter.curate(jsonArray.get(i).getAsJsonObject(), start, -1);
                }
            }
            if (this.json.has("item_displays")) {
                JsonArray jsonArray = this.json.get("item_displays").getAsJsonArray();
                for (i = 0; i < jsonArray.size(); ++i) {
                    TARDISItemDisplaySetter.fakeBlock(jsonArray.get(i).getAsJsonObject(), start, -1);
                }
            }
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = -1;
        }
        JsonArray level = (JsonArray)this.arr.get(this.l);
        JsonArray jsonArray = (JsonArray)level.get(this.r);
        for (int c = 0; c <= this.d; ++c) {
            JsonObject col = jsonArray.get(c).getAsJsonObject();
            BlockData data = this.plugin.getServer().createBlockData(col.get("data").getAsString());
            Block block = this.world.getBlockAt(this.x + this.r, this.y + this.l, this.z + c);
            if (!block.getType().isAir() && this.plugin.getBlockLogger().isLogging()) {
                this.plugin.getBlockLogger().logRemoval(block);
            }
            switch (data.getMaterial()) {
                case AIR: 
                case CAVE_AIR: 
                case VOID_AIR: {
                    block.setBlockData(data, true);
                    break;
                }
                case REDSTONE_TORCH: {
                    this.postRedstoneTorches.put(block, data);
                    break;
                }
                case REDSTONE: {
                    this.postRedstoneDust.put(block, data);
                    break;
                }
                case STICKY_PISTON: {
                    this.postPistons.put(block, data);
                    break;
                }
                case PLAYER_HEAD: 
                case PLAYER_WALL_HEAD: {
                    UUID uuid;
                    JsonObject head;
                    block.setBlockData(data, true);
                    JsonObject jsonObject = head = col.has("head") ? col.get("head").getAsJsonObject() : null;
                    if (head == null || !head.has("uuid") || (uuid = UUID.fromString(head.get("uuid").getAsString())) == null) break;
                    TARDISHeadSetter.textureSkull(this.plugin, uuid, head, block);
                    break;
                }
                case DECORATED_POT: {
                    TARDISBlockSetters.setBlock(this.world, this.x, this.y, this.z, data);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (col.has("pot")) {
                            JsonObject pot = col.get("pot").getAsJsonObject();
                            TARDISPotSetter.decorate(this.plugin, pot, block);
                        }
                    }, 1L);
                    break;
                }
                default: {
                    JsonObject state;
                    if (Tag.BANNERS.isTagged((Keyed)data.getMaterial())) {
                        JsonObject jsonObject = state = col.has("banner") ? col.get("banner").getAsJsonObject() : null;
                        if (state == null) break;
                        TARDISBannerData tbd = new TARDISBannerData(data, state);
                        this.postBanners.put(block, tbd);
                        break;
                    }
                    if (Tag.ALL_SIGNS.isTagged((Keyed)data.getMaterial())) {
                        JsonObject jsonObject = state = col.has("sign") ? col.get("sign").getAsJsonObject() : null;
                        if (state == null) break;
                        block.setBlockData(data, true);
                        TARDISSignSetter.setSign(block, state, null, 0);
                        break;
                    }
                    block.setBlockData(data, true);
                    if (!this.plugin.getBlockLogger().isLogging()) break;
                    this.plugin.getBlockLogger().logPlacement(block);
                }
            }
            if (c == this.d && this.r < this.w) {
                ++this.r;
            }
            if (c != this.d || this.r != this.w || this.l >= this.h) continue;
            this.r = 0;
            ++this.l;
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

