/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.customblocks;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronPowered;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;

public class ArtronFurnaceUtils {
    public static Block find(Block block, TARDIS plugin) {
        for (BlockFace face : TARDIS.plugin.getGeneralKeeper().getBlockFaces()) {
            Block other = block.getRelative(face);
            if (other.getType() != Material.FURNACE || !plugin.getTardisHelper().isArtronFurnace(other)) continue;
            return other;
        }
        return null;
    }

    public static boolean isTARDISPowered(String location, TARDIS plugin) {
        ResultSetArtronPowered rs = new ResultSetArtronPowered(plugin);
        return (Boolean)rs.fromLocation(location).getFirst();
    }

    public static void drain(int id, TARDIS plugin) {
        int drain = plugin.getArtronConfig().getInt("artron_furnace.power_drain");
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        plugin.getQueryFactory().alterEnergyLevel("tardis", -drain, where, null);
    }

    public static void register(String location, Player player, TARDIS plugin) {
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("uuid", player.getUniqueId().toString());
        ResultSetTravellers rst = new ResultSetTravellers(plugin, wheres, false);
        if (!rst.resultSet()) {
            plugin.getMessenger().message((CommandSender)player, TardisModule.TARDIS, "NOT_IN_TARDIS");
            return;
        }
        int id = rst.getTardis_id();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(plugin, where, "", false);
        if (!rs.resultSet()) {
            return;
        }
        Tardis tardis = rs.getTardis();
        if (!tardis.isTardisInit()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NO_INIT");
            return;
        }
        if (tardis.getFurnaces() >= plugin.getArtronConfig().getInt("artron_furnace.power_limit")) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_POWERED_LIMIT");
            return;
        }
        if (ArtronFurnaceUtils.isTARDISPowered(location, plugin)) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_ALREADY_POWERED", "furnace");
            return;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("tardis_id", id);
        set.put("location", location);
        plugin.getQueryFactory().doInsert("artron_powered", set);
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_POWERED", "furnace");
    }

    public static void remove(String location, Player player, TARDIS plugin) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("location", location);
        plugin.getQueryFactory().doDelete("artron_powered", where);
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_UNPOWERED", "furnace");
    }

    public static void removeFromCapacitor(Block block, Player player, TARDIS plugin) {
        Block furnace;
        TARDISDisplayItem display;
        ItemDisplay itemDisplay = TARDISDisplayItemUtils.get(block);
        if (itemDisplay != null && (display = TARDISDisplayItemUtils.get(itemDisplay)) == TARDISDisplayItem.ARTRON_CAPACITOR_STORAGE && (furnace = ArtronFurnaceUtils.find(block, plugin)) != null) {
            ArtronFurnaceUtils.remove(furnace.getLocation().toString(), player, plugin);
        }
    }
}

