/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.converters.lookup.LegacyColourTable;
import me.eccentric_nz.TARDIS.database.converters.lookup.LegacyIdTable;
import me.eccentric_nz.TARDIS.database.converters.lookup.LegacyTypeTable;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

public class TARDISMaterialIDConverter {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final List<Integer> COLOURED = List.of(Integer.valueOf(35), Integer.valueOf(95), Integer.valueOf(159), Integer.valueOf(160), Integer.valueOf(171), Integer.valueOf(251), Integer.valueOf(252));

    public TARDISMaterialIDConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCondenserData() {
        Statement statement = null;
        Statement ps = null;
        ResultSet rs = null;
        String query = "SELECT c_id, block_data FROM " + this.prefix + "condenser";
        String update = "UPDATE " + this.prefix + "condenser SET block_data = ? WHERE c_id = ?";
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            statement = this.connection.prepareStatement(query);
            ps = this.connection.prepareStatement(update);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    int c_id = rs.getInt("c_id");
                    String blockData = rs.getString("block_data");
                    try {
                        Material.valueOf((String)blockData);
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.debug("Condenser data was not a valid Material");
                        String mat = LegacyTypeTable.LOOKUP.get(blockData);
                        if (mat != null) {
                            ps.setString(1, mat);
                            ps.setInt(2, c_id);
                            ps.addBatch();
                        }
                        ++i;
                    }
                }
                if (i > 0) {
                    ps.executeBatch();
                    this.connection.commit();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " condenser IDs to material names");
                }
            }
            this.plugin.getConfig().set("conversions.condenser_materials", (Object)true);
            this.plugin.saveConfig();
        }
        catch (SQLException e) {
            this.plugin.debug("Conversion error for condenser materials! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing condenser table (converting IDs)! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPlayerPrefsData() {
        Statement statement = null;
        Statement ps = null;
        ResultSet rs = null;
        String query = "SELECT pp_id, wall, floor, siege_wall, siege_floor FROM " + this.prefix + "player_prefs";
        String update = "UPDATE " + this.prefix + "player_prefs SET wall = ?, floor = ?, siege_wall = ?, siege_floor = ? WHERE pp_id = ?";
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            statement = this.connection.prepareStatement(query);
            ps = this.connection.prepareStatement(update);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    String newSiegeFloor;
                    String newSiegeWall;
                    String newFloor;
                    String newWall;
                    String siegeFloor;
                    String siegeWall;
                    String floor;
                    String wall;
                    block28: {
                        String mat;
                        block27: {
                            block26: {
                                block25: {
                                    wall = rs.getString("wall");
                                    floor = rs.getString("floor");
                                    siegeWall = rs.getString("siege_wall");
                                    siegeFloor = rs.getString("siege_floor");
                                    newWall = rs.getString("wall");
                                    newFloor = rs.getString("floor");
                                    newSiegeWall = rs.getString("siege_wall");
                                    newSiegeFloor = rs.getString("siege_floor");
                                    try {
                                        Material.valueOf((String)wall);
                                    }
                                    catch (IllegalArgumentException e) {
                                        mat = LegacyTypeTable.LOOKUP.get(wall);
                                        if (mat == null) break block25;
                                        newWall = mat;
                                    }
                                }
                                try {
                                    Material.valueOf((String)floor);
                                }
                                catch (IllegalArgumentException e) {
                                    mat = LegacyTypeTable.LOOKUP.get(floor);
                                    if (mat == null) break block26;
                                    newFloor = mat;
                                }
                            }
                            try {
                                Material.valueOf((String)siegeWall);
                            }
                            catch (IllegalArgumentException e) {
                                mat = LegacyTypeTable.LOOKUP.get(siegeWall);
                                if (mat == null) break block27;
                                newSiegeWall = mat;
                            }
                        }
                        try {
                            Material.valueOf((String)siegeFloor);
                        }
                        catch (IllegalArgumentException e) {
                            mat = LegacyTypeTable.LOOKUP.get(siegeFloor);
                            if (mat == null) break block28;
                            newSiegeFloor = mat;
                        }
                    }
                    if (wall.equals(newWall) && floor.equals(newFloor) && siegeWall.equals(newSiegeWall) && siegeFloor.equals(newSiegeFloor)) continue;
                    int pp_id = rs.getInt("pp_id");
                    ps.setString(1, newWall);
                    ps.setString(2, newFloor);
                    ps.setString(3, newSiegeWall);
                    ps.setString(4, newSiegeFloor);
                    ps.setInt(5, pp_id);
                    ps.addBatch();
                    ++i;
                }
                if (i > 0) {
                    ps.executeBatch();
                    this.connection.commit();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " player_prefs IDs to material names");
                }
            }
            this.plugin.getConfig().set("conversions.player_prefs_materials", (Object)true);
            this.plugin.saveConfig();
        }
        catch (SQLException e) {
            this.plugin.debug("Conversion error for player_prefs materials! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing player_prefs table (converting IDs)! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockData() {
        Statement checker = null;
        Statement statement = null;
        Statement ps = null;
        ResultSet rs = null;
        String check = this.plugin.getConfig().getString("storage.database").equals("sqlite") ? "SELECT sql FROM sqlite_master WHERE tbl_name = '" + this.prefix + "blocks' AND sql LIKE '%block INTEGER DEFAULT 0%'" : "SHOW COLUMNS FROM " + this.prefix + "blocks LIKE 'block'";
        String query = "SELECT b_id, block, data FROM " + this.prefix + "blocks";
        String update = "UPDATE " + this.prefix + "blocks SET data = ? WHERE b_id = ?";
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            checker = this.connection.createStatement();
            ResultSet rsfc = checker.executeQuery(check);
            if (rsfc.next()) {
                statement = this.connection.prepareStatement(query);
                ps = this.connection.prepareStatement(update);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        int b_id = rs.getInt("b_id");
                        int block = rs.getInt("block");
                        int data = rs.getInt("data");
                        Material material = LegacyIdTable.LOOKUP.get(block);
                        if (material != null) {
                            if (data != 0 && this.COLOURED.contains(block)) {
                                String white = material.toString();
                                String[] tmp = white.split("_");
                                String colour = white.replace(tmp[0], LegacyColourTable.LOOKUP.get(data));
                                material = Material.valueOf((String)colour);
                            }
                            ps.setString(1, material.createBlockData().getAsString());
                        } else {
                            this.plugin.debug("Could not convert legacy material, defaulting to AIR!");
                            ps.setString(1, TARDISConstants.AIR.getAsString());
                        }
                        ps.setInt(2, b_id);
                        ps.addBatch();
                        ++i;
                    }
                    if (i > 0) {
                        ps.executeBatch();
                        this.connection.commit();
                        this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " blocks IDs to material names");
                    }
                }
            }
            this.plugin.getConfig().set("conversions.block_materials", (Object)true);
            this.plugin.saveConfig();
        }
        catch (SQLException e) {
            this.plugin.debug("Conversion error for blocks materials! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (checker != null) {
                    checker.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing blocks table (converting ID & data)! " + e.getMessage());
            }
        }
    }
}

