/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.flight.FlightReturnData;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class FlightPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;

    public FlightPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    public void save() {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "flight (uuid, tardis_id, location, stand) VALUES (?, ?, ?, ?)");
            for (Map.Entry<UUID, FlightReturnData> map : this.plugin.getTrackerKeeper().getFlyingReturnLocation().entrySet()) {
                this.ps.setString(1, map.getKey().toString());
                this.ps.setInt(2, map.getValue().id());
                this.ps.setString(3, map.getValue().location().toString());
                this.ps.setString(4, map.getValue().stand().toString());
                this.count += this.ps.executeUpdate();
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " flying TARDISes.");
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for flight table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing flight statement: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            this.ps = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "flight");
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                String u = this.rs.getString("uuid");
                String s = this.rs.getString("stand");
                String d = this.rs.getString("display");
                try {
                    UUID uuid = UUID.fromString(u);
                    int id = this.rs.getInt("tardis_id");
                    Location location = TARDISStaticLocationGetters.getLocationFromBukkitString(this.rs.getString("location"));
                    UUID stand = !s.isEmpty() ? UUID.fromString(s) : TARDISConstants.UUID_ZERO;
                    UUID display = !s.isEmpty() ? UUID.fromString(d) : TARDISConstants.UUID_ZERO;
                    this.plugin.getTrackerKeeper().getFlyingReturnLocation().put(uuid, new FlightReturnData(id, location, -1, -1, stand, display));
                    ++this.count;
                }
                catch (IllegalArgumentException e) {
                    this.plugin.debug("Could not load flying TARDIS with player UUID '" + u + "', stand UUID '" + s + "'' and display UUID '" + d + "'");
                }
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.count + " flying TARDISes.");
            }
            this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "flight");
            this.ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for flight table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing flight statement or resultset: " + ex.getMessage());
            }
        }
    }
}

