/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.howto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.howto.TARDISHowtoWallsInventory;
import me.eccentric_nz.TARDIS.howto.TARDISSeedsInventory;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TARDISWallFloorMenuListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, Integer> scroll = new HashMap();
    private final List<UUID> scrolling = new ArrayList<UUID>();
    private final ItemStack[][] blocks;
    private final int rows;

    public TARDISWallFloorMenuListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.rows = TARDISWalls.BLOCKS.size() / 8 + 1;
        this.blocks = this.getWallBlocks();
    }

    @EventHandler
    public void onWallFloorMenuOpen(InventoryOpenEvent event) {
        if (event.getInventory().getHolder(false) instanceof TARDISHowtoWallsInventory) {
            Player p = (Player)event.getPlayer();
            this.scroll.put(p.getUniqueId(), 0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWallFloorMenuClick(InventoryClickEvent event) {
        InventoryView view = event.getView();
        if (!(event.getInventory().getHolder(false) instanceof TARDISHowtoWallsInventory)) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        UUID uuid = p.getUniqueId();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("TARDISWallFloorMenuListener");
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        switch (slot) {
            case 8: {
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, this.scroll.get(uuid) + 1, true, uuid);
                break;
            }
            case 26: {
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, this.scroll.get(uuid) - 1, false, uuid);
                break;
            }
            case 44: {
                this.back(p);
                break;
            }
            case 53: {
                this.close(p);
                break;
            }
        }
    }

    @Override
    public void close(Player player) {
        this.plugin.getTrackerKeeper().getHowTo().remove(player.getUniqueId());
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Player)player).closeInventory(), 1L);
    }

    private void back(Player p) {
        this.close(p);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> p.openInventory(new TARDISSeedsInventory(this.plugin, p).getInventory()), 2L);
    }

    private void scroll(InventoryView view, int row, boolean up, UUID uuid) {
        if (up && row < this.rows - 5 || !up && row >= 0) {
            this.scroll.put(uuid, row);
            this.setSlots(view, row, uuid);
        } else {
            this.scrolling.remove(uuid);
        }
    }

    private void setSlots(InventoryView view, int row, UUID uuid) {
        int slot = 0;
        for (int r = row; r < row + 6; ++r) {
            for (int c = 0; c < 8; ++c) {
                view.setItem(slot, this.blocks[r][c]);
                if (slot % 9 == 7) {
                    slot += 2;
                    continue;
                }
                ++slot;
            }
        }
        this.scrolling.remove(uuid);
    }

    private ItemStack[][] getWallBlocks() {
        ItemStack[][] stacks = new ItemStack[this.rows][8];
        int r = 0;
        int c = 0;
        for (Material entry : TARDISWalls.BLOCKS) {
            ItemStack is;
            stacks[r][c] = is = ItemStack.of((Material)entry, (int)1);
            if (++c != 8) continue;
            ++r;
            c = 0;
        }
        return stacks;
    }
}

