/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.mobfarming;

import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Follower;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.monsters.judoon.JudoonEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.k9.K9Equipment;
import me.eccentric_nz.tardisweepingangels.monsters.ood.OodEquipment;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.nms.TWAFollower;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class TARDISFollowerSpawner {
    private final TARDIS plugin;

    public TARDISFollowerSpawner(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void spawn(List<Follower> followers, Location location, Player player, COMPASS direction, boolean enter) {
        Location pl = location.clone();
        if (enter) {
            pl.setZ(location.getZ() + 1.0);
        } else {
            switch (direction) {
                case NORTH: {
                    pl.add(1.0, 0.0, 1.0);
                    break;
                }
                case WEST: {
                    pl.add(1.0, 0.0, -1.0);
                    break;
                }
                case SOUTH: {
                    pl.add(-1.0, 0.0, -1.0);
                    break;
                }
                default: {
                    pl.add(-1.0, 0.0, 1.0);
                }
            }
        }
        for (Follower f : followers) {
            this.plugin.setTardisSpawn(true);
            TWAFollower follower = new MonsterSpawner().createFollower(pl, new Follower(f.getUuid(), f.getOwner(), f.getSpecies(), true, f.hasOption(), f.getColour(), f.getAmmo()));
            LivingEntity husk = (LivingEntity)follower.getBukkitEntity();
            if (f.getSpecies().equals((Object)Monster.JUDOON)) {
                JudoonEquipment.set((OfflinePlayer)player, husk, false);
            } else if (f.getSpecies().equals((Object)Monster.K9)) {
                K9Equipment.set((OfflinePlayer)player, husk, false);
            } else if (f.getSpecies().equals((Object)Monster.OOD)) {
                OodEquipment.set((OfflinePlayer)player, husk, false);
            }
            follower.setFollowing(true);
        }
        followers.clear();
    }

    public void spawnDivisionOod(Location location) {
        this.plugin.setTardisSpawn(true);
        LivingEntity husk = (LivingEntity)new MonsterSpawner().createFollower(location.clone().add(0.5, 0.0, 0.5), new Follower(UUID.randomUUID(), TARDISWeepingAngels.UNCLAIMED, Monster.OOD)).getBukkitEntity();
        this.plugin.getTardisAPI().setOodEquipment(husk, false);
    }

    public void removeDivisionOod(Location location) {
        for (Entity a : location.getWorld().getNearbyEntities(location, 32.0, 8.0, 32.0, e -> e.getType() == EntityType.ARMOR_STAND || e.getType() == EntityType.HUSK)) {
            UUID uuid;
            if (!a.getPersistentDataContainer().has(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID) || !a.getPersistentDataContainer().has(TARDISWeepingAngels.OOD, TARDISWeepingAngels.PersistentDataTypeUUID) || !TARDISWeepingAngels.UNCLAIMED.equals(uuid = (UUID)a.getPersistentDataContainer().get(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID))) continue;
            a.remove();
        }
    }
}

